.set noat
.set noreorder
.global FlushCache
.global EnableIntc
.text
	nop
	nop

		.globl Init_GS_PAL
		.globl Init_GS_NTSC
		.globl Init_GS
		.align 4

Init_GS_PAL:
		addiu	$sp,$sp,-64	#MIPS calling convention - store s0-s8 if changed
		sd	$19,32($sp)	#should v0-v1 and a0-a3 be stored too?
		sd	$18,16($sp)
		sd	$17,0($sp)
	
                li      $6,3            # 2=NTSC, 3=PAL
		beql    $0,$0,pal_mode
		nop	

Init_GS_NTSC:
		addiu	$sp,$sp,-64	#MIPS calling convention - store s0-s8 if changed
		sd	$19,32($sp)	#should v0-v1 and a0-a3 be stored too?
		sd	$18,16($sp)
		sd	$17,0($sp)
	
                li      $6,2            # 2=NTSC, 3=PAL
		beql    $0,$0,pal_mode
		nop	
	
Init_GS:
		addiu	$sp,$sp,-64	#MIPS calling convention - store s0-s8 if changed
		sd	$19,32($sp)	#should v0-v1 and a0-a3 be stored too?
		sd	$18,16($sp)
		sd	$17,0($sp)
	
# The following is taken from 3stars by Duke:
	
                lui     $2,0x1fc8
                lb      $2,-0xae($2)
                li      $3,'E'
                li      $6,2                  # 2=NTSC, 3=PAL
                beql    $2,$3,pal_mode
		nop
	        addiu   $6,1
pal_mode:
		li	$5,1			# 0=NON, 1=INTERLACE
		li	$7,0			# 1=frame, 2=field


		addu	$17,$5,$0
		addu	$18,$6,$0
		addu	$19,$7,$0
		li	$3,0x12001000
		li	$2,0x00000200
		sd	$2,0($3)	# write 0x200 to 0x12001000 (=GS reset)
		li	$4,0x0000FF00
		ld	$2,0($3)
		dsrl	$2,16
		andi	$2,0xFF
		li	$3,0x71		# PutIMR(kernel)
		syscall
		nop
		andi	$4,$17,1
		andi	$5,$18,0xFF
		andi	$6,$19,1
		li	$3,2		# SetGsCrt(kernel)
		syscall
		nop

		ld	$19,32($sp)	# restore s0-s8
		ld	$18,16($sp)
		ld	$17,0($sp)
		jr	$31
		addiu	$sp,$sp,64



	
# Missing syscall in ps2lib??
		.align 4
EnableIntc:
	li	$3, 0x14
	syscall	
	jr	$31		
	nop

	
	
	
# From early version of Gustavo's lib:	
	
############################################ syscall  
#                                            k_GetThreadID ##
	.globl	GetThreadID
	.ent	GetThreadID
GetThreadID:
	li	$3, 47
	syscall
	jr	$31
	nop
	.end	GetThreadID

