///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSYSTEM_H
#define THERESA_THSYSTEM_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThSystem : public IThSystem, public ThServerObject
{
public:
// constructors
																		ThSystem(void);
																		~ThSystem(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	bool															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
// interface display methods
	bool															openDisplay(const ThContextMode* mode = NULL);
	void															closeDisplay(void);
// interface music methods
	bool															openMusic(const char* fileName);
	void															closeMusic(void);
// interface effect methods
	bool															openEffect(void);
	void															closeEffect(void);
// interface engine methods
	bool															openEngine(void);
	void															closeEngine(void);
// interface attributes
	bool															isStarted(void);
	bool															isPaused(void);
	float															getTime(void);
	void															setTime(float time);
	IThDisplay*												getDisplay(void);
	IThMusic*													getMusic(void);
	IThEffect*												getEffect(void);
	IThEngine*												getEngine(void);
private:
// callbacks
	bool															receive(const IThMessage* message);
// data
	float															m_prevTime;
	ThTimer														m_timer;
	ThPtr<IThDisplay>									m_display;
	ThPtr<IThMusic>										m_music;
	ThPtr<IThEffect>									m_effect;
	ThPtr<IThEngine>									m_engine;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSYSTEM_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
