///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSERVER_H
#define SHARED_THSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	THID_INVALID,

	THID_ANNOUNCE,

	THID_SERVER,
	THID_CLIENT,
	THID_CONTEXT,
	THID_DISPLAY,
	THID_MUSIC,
	THID_EFFECT,
	THID_SYSTEM,

	THID_CUSTOM_BASE = 1000,
};

enum
{
	THMSG_INVALID,

	THMSG_LOCAL_UPDATE,						// float
	THMSG_LOCAL_RENDER,

	THMSG_REQUEST_EXIT,

	THMSG_SERVER_STOP,
	THMSG_SERVER_UPDATE,

	THMSG_CONTEXT_RESIZE,
	THMSG_CONTEXT_ACTIVATE,
	THMSG_CONTEXT_DEACTIVATE,

	THMSG_DISPLAY_OPEN,
	THMSG_DISPLAY_CLOSE,
	THMSG_DISPLAY_RESIZE,

	THMSG_MUSIC_OPEN,
	THMSG_MUSIC_CLOSE,
	THMSG_MUSIC_SYNCH,							// unsigned char

	THMSG_EFFECT_OPEN,
	THMSG_EFFECT_CLOSE,

	THMSG_ENGINE_OPEN,
	THMSG_ENGINE_CLOSE,

	THMSG_SYSTEM_START,
	THMSG_SYSTEM_STOP,
	THMSG_SYSTEM_PAUSE,
	THMSG_SYSTEM_RESUME,

	THMSG_CUSTOM_BASE = 1000,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! Starts the system message loop. This function returns when the application is terminated, or after the system message loop has been stopped.
 *	\param listenerID [in]The id of the object to notify of each frame update, or THID_INVALID to disable notification.
 */
void startSystemMessageLoop(unsigned int listenerID = THID_INVALID);

/*! Signals the system message loop to stop at the first appropriate time.
 */
void stopSystemMessageLoop(void);

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThServerObject : public ThListItem<ThServerObject>
{
public:
// constructors
																		ThServerObject(unsigned int id = THID_INVALID);
	virtual														~ThServerObject(void);
// callbacks
	virtual bool											receive(const IThMessage* message);
// attributes
	unsigned int											getID(void) const;
protected:
// methods
	void															sendMessage(unsigned int message, unsigned int toID);
	void															sendMessage(unsigned int message, unsigned int toID, const void* data, unsigned int size);
	void															postMessage(unsigned int message, unsigned int toID);
	void															postMessage(unsigned int message, unsigned int toID, const void* data, unsigned int size);
private:
// data
	unsigned int											m_id;
};

//-------------------------------------------------------------------------------------------------

/*! \class ThClient
 *	Application client class.
 */
class ThClient : public ThServerObject
{
public:
// constructors
																		ThClient(void);
	virtual														~ThClient(void);
// callbacks
	virtual bool											receive(const IThMessage* message);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \class IThMessage
 *	Message information class.
 */
class IThMessage
{
public:
// constructors
	virtual														~IThMessage(void);
// attributes
	virtual unsigned int							getToID(void) const = 0;
	virtual unsigned int							getFromID(void) const = 0;
	virtual unsigned int							getMessage(void) const = 0;
	virtual const void*								getData(void) const = 0;
	virtual unsigned int							getSize(void) const = 0;
};

//-------------------------------------------------------------------------------------------------

/*! \class IThServer
 *	Message server singleton class.
 */
class IThServer
{
public:
// constructors
	virtual														~IThServer(void);
// methods
	virtual void											sendMessage(unsigned int message, unsigned int toID, unsigned int fromID) = 0;
	virtual void											sendMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data, unsigned int size) = 0;
	virtual void											postMessage(unsigned int message, unsigned int toID, unsigned int fromID) = 0;
	virtual void											postMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data, unsigned int size) = 0;
// object methods
	virtual unsigned int							createObjectID(void) = 0;
	virtual bool											registerObject(ThServerObject* object) = 0;
	virtual ThServerObject*						findObject(unsigned int id) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThServer> Server;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSERVER_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
