#!/bin/sh

source_dir=src

if test "$1" = "--help"; then
	echo "synopsis:" $0 "[DIRECTORY=src]"
	echo "Calculates the number of lines in the specified source tree, "$source_dir" by default."
	exit 0
elif test "$1" = "--"; then
	if test ! -z "$2"; then
		source_dir=$2
	else
		exit 1
	fi
elif test ! -z "$1"; then
	source_dir=$1
fi

if test ! -d "$source_dir"; then
	echo $0": Could not find source directory "$source_dir"."
	exit 1
fi

expr `for file in \`find $source_dir -name "Th*.cpp" -o -name "Th*.hpp" -o -name "Th*.h"\`; do printf "%u + " \`cat $file | wc -l\`; done; echo 0`
