
int start(void);

class DemoApp : public ThApplication
{
public:
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool receive(const IThMessage* message);
};

class DemoSuper : public ThEffectObject
{
public:
	DemoSuper(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		COLOR = THATTR_CUSTOM_BASE,
	};
private:
	ThVector3 m_oldColor;
	ThVector3 m_newColor;
	ThVector3 m_curColor;
	float m_moment;
};

class DemoIntro : public ThEffectObject
{
public:
	DemoIntro(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		VIBRATE = THATTR_CUSTOM_BASE,
	};
private:
	void renderVertex(const ThVector4& vertex, const ThMatrix4& transform);
	ThBlock<ThVector4> m_vertices;
	IThMaterial* m_material;
	float m_moment;
	bool m_active;
};

class DemoOrgan : public ThEffectObject
{
public:
	DemoOrgan(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		NOTE = THATTR_CUSTOM_BASE,
	};
private:
	IThMesh* m_white;
	IThMesh* m_green;
	ThPtr<IThLight> m_light;
	ThVector3 m_position[6];
	ThVector3 m_speed[6];
	ThVector3 m_accel[6];
};

class DemoPommes : public ThEffectObject
{
public:
	DemoPommes(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		LIGHT = THATTR_CUSTOM_BASE,
	};
private:
	IThMesh* m_mesh;
	ThPtr<IThLight> m_light;
	float m_moments[4];
	bool m_active[4];
	float m_moment;
	IThMaterial* m_materials[4];
	ThVector4 m_color;
	ThVector3 m_vector;
};

class DemoCredits : public ThEffectObject
{
public:
	DemoCredits(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		MEMBER = THATTR_CUSTOM_BASE,
		EXPLODE,
	};
private:
	ThBlock<IThMesh*> m_meshes;
	ThBlock<IThTexture*> m_textures;
	ThPtr<IThLight> m_light;
	ThParticleSystem m_system;
	bool m_exploded;
	unsigned int m_member;
	float m_moment;
	bool m_active;
	ThBlock<ThVector3> m_vectors;
	ThBlock<float> m_intervals;
	ThBlock<float> m_elapsed;
	ThPtr<IThMaterial> m_lineMaterial;
	ThPtr<IThMaterial> m_textMaterial;
	ThPtr<IThMaterial> m_bombMaterial;
};

class DemoOlive : public ThEffectObject
{
public:
	DemoOlive(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		SPEED = THATTR_CUSTOM_BASE,
		DIRECTION,
	};
private:
	IThMesh* m_mesh;
	ThPtr<IThLight> m_light;
	IThTexture* m_overlay;
	ThVector3 m_vector;
	float m_speed;
};

class DemoHyper : public ThEffectObject
{
public:
	DemoHyper(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
	enum
	{
		STOP = THATTR_CUSTOM_BASE,
	};
private:
	ThBlock<float> m_angles;
	ThBlock<IThMesh*> m_meshes;
	ThPtr<IThLight> m_light;
	bool m_stopped;
};

class DemoLens : public ThEffectObject
{
public:
	DemoLens(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
private:
	void render(void);
	ThBlock<IThTexture*> m_symbols;
	ThBlock<IThTexture*> m_faces;
	ThBlock<ThVector2> m_positions;
	ThPtr<IThCanvas> m_canvas;
	ThPtr<IThTexture> m_texture;
	ThPtr<IThMaterial> m_faceMaterial;
	ThPtr<IThMaterial> m_symbolMaterial;
	ThPtr<IThMaterial> m_renderMaterial;
};

class DemoGreets : public ThEffectObject
{
public:
	DemoGreets(ThEffectType* type, const char* name);
	bool open(void);
	bool update(float deltaTime);
	bool render(IThCanvas* target);
	bool notify(unsigned int attributeID, const char* value);
private:
	struct Point
	{
		float size;
		float offset;
		float position;
		unsigned int index;
	};
	ThBlock<Point> m_points;
	ThRange<float> m_size;
	ThRange<float> m_offset;
	ThBlock<IThTexture*> m_textures;
	ThPtr<IThMaterial> m_material;
	ThBlock<IThTexture*> m_texts;
	unsigned int m_index;
};
