import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;

/**
 * Example02 introduces Java 2D Shapes, GeneralPath, and transforms.
 * <p>
 * IMPORTANT:  This source code example is offered under the license at:
 * http://wireless.java.sun.com/berkeley_license.html
 *
 * @author Bill Day <bill.day@sun.com>
 * @version 1.1
 * @see java.awt.Graphics2D
 * @see java.awt.geom.AffineTransform
 * @see java.awt.geom.GeneralPath
**/

public class Example02 extends Frame {
  /**
   * Instantiates an Example02 object.
   **/
  public static void main(String args[]) {
    new Example02();
  }

  /**
   * Our Example02 constructor sets the frame's size, adds the
   * visual components, and then makes them visible to the user.
   * It uses an adapter class to deal with the user closing
   * the frame.
   **/
  public Example02() {
    //Title our frame.
    super("Java 2D Example02, Shapes and Transforms");

    //Set the size for this frame.
    setSize(400,300); 

    //We need to turn on the visibility of our frame
    //by setting the Visible parameter to true.
    setVisible(true);

    //Now, we want to be sure we properly dispose of resources 
    //this frame is using when the window is closed.  We use 
    //an anonymous inner class adapter for this.
    addWindowListener(new WindowAdapter() 
      {public void windowClosing(WindowEvent e) 
         {dispose(); System.exit(0);}  
      }
    );
  }

  /**
   * Here we use new Java 2D API features such as affine 
   * transforms and Shape objects (in this case, a generic
   * one, GeneralPath).
   **/
  public void paint(Graphics g) {
    //Here is how we used to draw a square with width
    //of 200, height of 200, and starting at x=50, y=50.
    g.setColor(Color.red);
    g.drawRect(50,50,200,200);
 
    //Let's set the Color to blue and then use the Graphics2D
    //object to draw a rectangle, offset from the square.
    //So far, we've not done anything using Graphics2D that
    //we could not also do using Graphics.  (We are actually
    //using Graphics2D methods inherited from Graphics.)
    Graphics2D g2d = (Graphics2D)g;
    g2d.setColor(Color.blue);
    g2d.drawRect(75,75,300,200);

    //Now, let's draw another rectangle, but this time, let's
    //use a GeneralPath to specify it segment by segment.
    //Furthermore, we're going to translate and rotate this 
    //rectangle relative to the Device Space (and thus, to
    //the first two quadrilaterals) using an AffineTransform.
    //We also will change its color.
    GeneralPath path = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
    path.moveTo(0.0f,0.0f);
    path.lineTo(0.0f,125.0f);
    path.lineTo(225.0f,125.0f);
    path.lineTo(225.0f,0.0f);
    path.closePath();

    AffineTransform at = new AffineTransform();
    at.setToRotation(-Math.PI/8.0);
    g2d.transform(at);
    at.setToTranslation(50.0f,200.0f);
    g2d.transform(at);

    g2d.setColor(Color.green);
    g2d.fill(path);
  }
}
