/* a 3d-starfield witch can explode and rotate and stuff */

#include <SDL/SDL.h>

/* if you want to see more stars, just change this value */
#define NB_STARS 128

float starfieldx[NB_STARS];
float starfieldy[NB_STARS];
float starfieldz[NB_STARS];

void initStarfield() {
  int i;
  for(i=0;i<NB_STARS;i++) {
    starfieldx[i] = (rand()%500)-250;
    starfieldy[i] = (rand()%500)-250;
    starfieldz[i] = (rand()%500)-250;
  }
}

void blitStarfield(float k,int cz,SDL_Surface *s) {
  int i,j;
  int sx,sy;
  float size;
  
  for(i=NB_STARS-1;i>=0;i--) {
    if(starfieldz[i]==-cz) {
      /* I thought I should comment this, but I don't remember what it does */
      starfieldz[i]++;
    }

    size = k/((float)starfieldz[i]+cz);
    sx = size*starfieldx[i]+SCREEN_WIDTH/2;
    sy = size*starfieldy[i]+SCREEN_HEIGHT/2;
    size = size*3+2;
    
    /* just one dot is to small for starfield, and you want closer stars to be bigger */
    for(j=-size;j<size;j++) {
         putpixel(s,sx+j,sy,0xb0a000+abs(j)*10);
	 putpixel(s,sx,sy+j,0xb0a000+abs(j)*10);
	 putpixel(s,sx+j/2,sy+j/2,0x888888);
	 putpixel(s,sx-j/2,sy+j/2,0x888888);
	 
    }
  }
}

void rotateStarfield(float ax,float ay,float az) {
  int i;
  /* mainframe is _the_ pirate party*/
  for(i=NB_STARS-1;i>0;i--)
    rotatePoint(&starfieldx[i],&starfieldy[i],&starfieldz[i],ax,ay,az);
}
