
void skapaPalett(SDL_Surface *screen,char *pFilnamn) {
   SDL_Color palette[256];
   SDL_Surface *pFil;
   Uint32 color;
   int i;

   pFil = IMG_Load(pFilnamn);
   for(i=0;i<256;i++) {
     color = getpixel2ARGB(pFil,i,1);
     palette[i].r = color>>16;
     palette[i].g = (color>>8)&0xff;
     palette[i].b = color&0xff;
   }
  SDL_SetColors(screen,palette,0,256);
}


void blitPlasma(SDL_Surface *screen) {
  Uint8 *p;
  static int apanap=0;
  int i,x,y;
  int attx[3];
  int atty[3];
  float f;
  float ap;
  static int first=1;
  static SDL_Surface *bild;
  

  if(first) {
    for(i=0;i<3;i++) {
      attx[i] = rand()%WIDTH;
      atty[i] = rand()%HEIGHT;
    }
    bild = SDL_CreateRGBSurface(SDL_SWSURFACE,WIDTH,HEIGHT,8,0,0,0,0);
    skapaPalett(bild,"data/plasmaPalette.png");
    first=0;
  }

  apanap++;
  ap = 90*sintab[(apanap<<2)%256];
  attx[0] = WIDTH/2 + 80*sintab[(apanap<<3)%256];
  atty[0] = HEIGHT/2 + 80*costab[(apanap<<3)%256];
  
  p = bild->pixels;
  for(y=0;y<HEIGHT;y++) {
    for(x=0;x<WIDTH;x++) {
      f=0;
      for(i=0;i<2;i++) {
	f += sintab[(int)(hypot(attx[i]-x,atty[i]-y)+ap)%256];
      }
      *p = (int)(128*(f+3));
      p++;
    }
  }
  SDL_BlitSurface(bild, 0, screen, 0);
}

void plasmaEffect(SDL_Surface *s) {
  static int first=1;
  static SDL_Surface *curve;

  if(first) {
    curve =IMG_Load("data/plasma-filter.png");
    SDL_SetColorKey(curve,SDL_SRCCOLORKEY,0xffffff);
    first=0;
  }
  
  blitPlasma(s);
  SDL_BlitSurface(curve, 0, s, 0);
}
