/*  gcc main.c -lSDL -lSDL_image -lpthread */
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

/* med de hr define-erna tror man att man kan ndra p upplsningen
   men det stmmer inte efterssom upplsningen r hrdkodat p andra stllen */
#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480

static int rings[288];

#include "basics2d.c"
#include "basics3d.c"
#include "font.c"
#include "music.c"
#include "starfield.c"
#include "hardware.c"
#include "bloob.c"
#include "slides.c"
#include "font.h"
#include "blippblopp.c"
#include "tub.c"
#include "inter.c"
#include "rotate.c"
#include "planets.c"
#include "credits.c"
#include "creation.c"
#include "plasma.c"
#include "earth.c"
#include "morotor.c"

void cleanup() {
  SDL_Quit();
  kill(0,SIGHUP);
}
/* hr r main-funktionen */
int main(int argc,char **argv) {
  SDL_Surface *screen,*fontimg;
  SDL_Surface *apg;
  SDL_Rect tmprect;
  SDL_Rect tmprect2;
  SDL_Event event;
  int done = 0;
  int i;
  SDL_Surface *tmp1;
  SDL_Surface *tmp2;
 
  int fullscreen=1;
  int nosound=0;

  int mtime;

  /* input parser */
  for(i=0;i<argc;i++) {
    if(strcmp(argv[i],"-w")==0) fullscreen=0;
    else if(strcmp(argv[i],"-ns")==0) nosound=1; 
  }

  atexit(cleanup);

  srand((unsigned)time(NULL));

  fontimg = IMG_Load("data/font.png");
  SDL_SetColorKey(fontimg,SDL_SRCCOLORKEY,0);

  if ( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0 ) {
    fprintf(stderr, "Unable to init SDL: %s\n", SDL_GetError());
    exit(1);
  }
  /* grs i cleanup() */
  //  atexit(SDL_Quit);
  int flags = SDL_SWSURFACE;
  if(fullscreen) flags = flags|SDL_FULLSCREEN;

  screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 32, flags);
  if ( screen == NULL ) { 
    fprintf(stderr, "Unable to set 640x480 video: %s\n", SDL_GetError());
    exit(1);
  }
  /* man vill inte ha cursor nr man kr fullscreen */
  if(fullscreen) SDL_ShowCursor(SDL_DISABLE);
    
  initStarfield();
  
  if(!nosound) {
    startMusic();
  }

  fillSintab();
  
  printf("start mainloop\n");

  tmp1 = SDL_CreateRGBSurface(screen->flags,screen->w,screen->h,screen->format->BitsPerPixel,
		    screen->format->Rmask,screen->format->Gmask,screen->format->Bmask,
		    screen->format->Amask);
  tmp2 = SDL_CreateRGBSurface(screen->flags,screen->w,screen->h,screen->format->BitsPerPixel,
		    screen->format->Rmask,screen->format->Gmask,screen->format->Bmask,
		    screen->format->Amask);
  apg = IMG_Load("data/apGroove.png");
  SDL_SetColorKey(apg,SDL_SRCCOLORKEY,0);
  
  /*
  tmp1 = IMG_Load("data/bluescreen.png");
  tmp2 = IMG_Load("data/pinkscreen.png");
  */
  while(!done) {
    mtime = SDL_GetTicks();
    SDL_FillRect(screen,0,0x000000);
    
    /* om man vill hoppa ver lite effekter s kan man avkomentera nn av de hr raderna */
    //  mtime+=35000+15000+10000+4000+6000;
    //  mtime+=35000+15000+10000+8000+4000+6000+4000;

    /* beroende p vad klockan r s krs olika ffekter, ballt va */
    if(mtime<35000) {
      creationEffekt(screen,mtime,fontimg);
    } else if(mtime<35000+15000) {
      bloobIntroEffect(screen,mtime,fontimg);
    } else if(mtime<35000+15000+10000) { 
      SDL_FillRect(tmp1,0,0);
      
      hardwareEffect(tmp1,fontimg,mtime);
      bloobIntroEffect(tmp2,mtime,fontimg);      
      
      
      if((mtime-35000-15000)/10.0<480) {
	sinVertSlide2(screen,tmp1,tmp2,(mtime-35000-15000)/10.0,mtime);
      } else {
	SDL_BlitSurface(tmp1,0,screen,0);
	/* ingen scroller hr inte */
	//	blippblopp(screen,mtime);
      
      }
    } else if(mtime<35000+15000+10000+8000) {
      blitStarfield(100,50,screen);
      blitPlanets(screen,mtime,2);
      blitString("apanap created the plasma planet",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000) {
      plasmaEffect(screen);
    } else if(mtime<35000+15000+10000+8000+4000+6000) {
      plasmaEffect(screen);
      tmprect.x = 400;
      tmprect.y = 20;
      SDL_BlitSurface(apg,0,screen,&tmprect);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000) {
      blitStarfield(100,50,screen);
      blitPlanets(screen,mtime,3);
      blitString("apanap created the earth",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+13000) {
      earthEffect(screen,mtime);
      blitString("mostly dull",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000) {
      earthEffect(screen,mtime);
      blitString("ohh groovy",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000) {
      /* did you now that most of the comments was added after we won the gnu-award? */
      blitStarfield(100,50,screen);
      blitPlanets(screen,mtime,4);
      blitString("apanap created the red planet",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000+5000) {
      morotorZoomer(SDL_GetTicks()/500.0,0,1,screen);
      blitString("morotorzoomer",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000+5000+4000) {
      blitStarfield(100,50,screen);
      blitPlanets(screen,mtime,5);
      blitString("apanap created dot morphing",10,10,screen,fontimg);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000+5000+30000) {
      SDL_FillRect(screen,0,0xffffff);
      rotate(screen,mtime);
      blippblopp(screen,mtime);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000+5000+30000+30000) {
      SDL_FillRect(screen,0,0xffffff);
      tub(screen,mtime);
      inter(screen,mtime);
      tub2(screen,mtime);
      blippblopp(screen,mtime);
    } else if(mtime<35000+15000+10000+8000+4000+6000+4000+17000+4000+5000+30000+30000+8000) {
      blitStarfield(100,50,screen);
      blitPlanets(screen,mtime,6);
      blitString("thus he saw that all was complete",10,10,screen,fontimg);
    } else {
      creditsEffect(screen,mtime,fontimg);
    }
    
    /* check if anything important has happend */
    SDL_PollEvent(&event);
    SDL_UpdateRect(screen,0,0,0,0);
    switch (event.type) {
    case SDL_KEYDOWN:
      if ( event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; }
      break;
    case SDL_QUIT:
      done=1;
    }
  }

  return 0;
}

