
void createICLineObject(float *x,float *y,float *z) {
  int w=70,h=120,d=5,pl=20,pins=8;
  int i;
  /*top*/
  x[0] = -w/2;
  y[0] = -h/2;
  z[0] = +d;
  x[1] = w/2;
  y[1] = -h/2;
  z[1] = +d;

  x[2] = w/2;
  y[2] = -h/2;
  z[2] = +d;
  x[3] = w/2;
  y[3] = h/2;
  z[3] = +d;

  x[4] = w/2;
  y[4] = h/2;
  z[4] = +d;
  x[5] = -w/2;
  y[5] = h/2;
  z[5] = +d;

  x[6] = -w/2;
  y[6] = h/2;
  z[6] = +d;
  x[7] = -w/2;
  y[7] = -h/2;
  z[7] = +d;

  /* lower square */
  x[8] = -w/2;
  y[8] = -h/2;
  z[8] = -d;
  x[9] = w/2;
  y[9] = -h/2;
  z[9] = -d;

  x[10] = w/2;
  y[10] = -h/2;
  z[10] = -d;
  x[11] = w/2;
  y[11] = h/2;
  z[11] = -d;

  x[12] = w/2;
  y[12] = h/2;
  z[12] = -d;
  x[13] = -w/2;
  y[13] = h/2;
  z[13] = -d;

  x[14] = -w/2;
  y[14] = h/2;
  z[14] = -d;
  x[15] = -w/2;
  y[15] = -h/2;
  z[15] = -d;

}

void createICPointObject(float *x,float *y,float *z) {
  int w=70,h=120,d=5,pl=20,pins=8;
  int i;
  x[0] = -w/2;
  y[0] = -h/2;
  z[0] = +d;
  x[1] = w/2;
  y[1] = -h/2;
  z[1] = +d;
  x[2] = w/2;
  y[2] = h/2;
  z[2] = +d;
  x[3] = -w/2;
  y[3] = h/2;
  z[3] = +d;

  x[4] = -w/2;
  y[4] = -h/2;
  z[4] = -d;
  x[5] = w/2;
  y[5] = -h/2;
  z[5] = -d;
  x[6] = w/2;
  y[6] = h/2;
  z[6] = -d;
  x[7] = -w/2;
  y[7] = h/2;
  z[7] = -d;

  for(i=0;i<pins;i++) {
    x[8+i]=-w/2;
    y[8+i]= -h/2 + h*(i/(float)(pins));
    z[8+i]= -d-pl;
  }
  for(i=0;i<pins;i++) {
    x[8+pins+i]= w/2;
    y[8+pins+i]= -h/2 + h*(i/(float)(pins));
    z[8+pins+i]= -d-pl;
  }

}

void hardwareEffect(SDL_Surface *s,SDL_Surface *fontimg,Uint32 mtime) {
  SDL_Rect tmprect;
  static int first=1;
  static SDL_Surface *board,*schema,*chip;
  int i;
  static float chipx[24],chipy[24],chipz[24],nchip=24;
  //float chipx[8],chipy[8],chipz[8],nchip=8;
  static int starttid;

  if(first) {
    /* this is a vga-sync-signal generator drawn i Eagle for
       a school project, it works (but doesn't do much */
    schema = IMG_Load("data/sync-sch.png");
    SDL_SetColorKey(schema,SDL_SRCCOLORKEY,0xffffff);
    chip = IMG_Load("data/74.png");
    /* the board layout is just bogus, auto-routed to fit the schematics */
    board = IMG_Load("data/sync-brd.png");
    SDL_SetColorKey(board,SDL_SRCCOLORKEY,0);


    createICPointObject(&chipx[0],&chipy[0],&chipz[0]);
    starttid = mtime;
    first=0;
  }

  mtime = mtime-starttid;

  tmprect.x =20;
  tmprect.y =20;
  SDL_SetAlpha(schema,SDL_SRCALPHA,128*sin(3.14+mtime/500.0)+128);
  SDL_BlitSurface(schema,0,s,&tmprect);
  SDL_SetAlpha(board,SDL_SRCALPHA,128*sin(mtime/500.0)+128);
  SDL_BlitSurface(board,0,s,&tmprect);
  tmprect.x = 480;
  tmprect.y = 80;
  
  SDL_BlitSurface(chip,0,s,&tmprect);
  
  for(i = 0;i<nchip;i++) {
    rotatePoint(&chipx[i],&chipy[i],&chipz[i],0.03,0.03,0);
  }
  /* the object you see is actually a dc-chip, but it's not that obvious and
     the function to draw lines instead never worked */
  blit3dPointObject(100,nchip,&chipx[0],&chipy[0],&chipz[0],560,300,200,s);
  // blit3dLineObject(100,nchip,&chipx[0],&chipy[0],&chipz[0],560,300,200,s);

  blitString("hardwaerch in space for real piratesh",20,460-FONTH,s,fontimg);
}
