/*
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <math.h>
#include <stdlib.h>
*/
#define WIDTH 640
#define HEIGHT 480

void incRectBloob(int *bloobfield,int x, int y, int w,int h,int strength) {
  int i,j;
  for(i=0;i<w;i++) for(j=0;j<h;j++) {
    bloobfield[x+i + (y+j)*WIDTH] += strength;
  }
}

int *initCircularBloob(int r,int strength) {
  int *circle;
  int x,y;
  int w = r*2;
  float d,maxd,k;
  maxd = r;
  /* we had a segfault on certain sizes of the bloob when we allocated only w*w+1 bytes
     dunno why but this seems to do the trick */
  circle = malloc((w*w+2)*sizeof(int));
  for(x=0;x<w;x++) for(y=0;y<w;y++) {
      d = hypot(abs(x - r) , abs(y - r));
      k = 1 - (d/maxd);
      if(k<0) k=0;
      circle[x+y*w]=(int)(strength*k*k);
      /* when writing a demo you must remember to remove all your debug printf's before showing on screen*/
      //      printf("%i\n",circle[x+y*w]);
  }
  circle[w*w+1] = -1;
  return &circle[0];
}

SDL_Surface *createLeavesSurface(SDL_Surface *s,SDL_Surface *l) {
  SDL_Rect rect;
  int i,antal_blad =255;
  
  printf("tjo\n");

  SDL_CreateRGBSurface(SDL_SWSURFACE,300,200,32,0xff0000,0xff00,0xff,0);
  
  for(i=0;i<antal_blad;i++) {
    rect.x = rand()%s->w;
    rect.y = rand()%s->h;
    printf("%i %i\n",rect.x,rect.y);
    SDL_BlitSurface(l,0,s,&rect);
  }
  
  return s;
}

void incArrayBloob(int *bf, int *bloob,int x, int y) {
  int p=0;
  int w;
  int i,j;
  while(bloob[p]!=-1) {
    p++;
  }
  p--;
  w = sqrt(p);
  for(i=0;i<w;i++) for(j=0;j<w;j++) {
    bf[i+x + (j+y)*WIDTH] += bloob[i+j*w];
  }
  
}
/* this method is what makes the bloobeffect so funny, a grayscaled surface
   is just as a bloob-forcefield. Hey this comment almost made sense */
void incSurfaceBloob(int *bf,SDL_Surface *img,int x, int y) {
  unsigned char *p;
  int i,j;
  p = img->pixels;
  for(i=0;i<img->w;i++) for(j=0;j<img->h;j++) {
    bf[(i+x)+(j+y)*WIDTH] += p[i+j*img->w];
  }
}

void blitBloobfield(int min,int med,Uint32 c1,Uint32 c2,int *bf,SDL_Surface *s){
  int i;
  int *p;

  p = s->pixels;
  for(i=0;i<WIDTH*HEIGHT;i++) {
    if(bf[i]>min) {
      if(bf[i]>med) {
	p[i] = c2;
      } else {
	p[i] = c1;
      }
    }
  }
}

void clearBloobfield(int *bf) {
  int i;
  for(i=WIDTH*HEIGHT-1;i>=0;i--) {
    bf[i]=0;
  }
}

void bloobIntroEffect(SDL_Surface *s,Uint32 mtime,SDL_Surface *font) {
  static int first = 1;
  static SDL_Surface *image;
  static SDL_Surface *bg;
  static int bloobfield[WIDTH*HEIGHT];
  static int *bloobCircle;
  static int starttid;
  int a;

  /* this is actually a quite cool effect, can't bother to explain it right now though */
  
  if(first) {
    bg = IMG_Load("data/bg.png");
    image = IMG_Load("data/bloob-logo.png");
    bloobCircle = initCircularBloob(64,100);  
    //      free(bloobCircle);
    starttid =mtime;
    first=0;
    printf("bloob's inited\n");
  }
  
 
  mtime = mtime-starttid;

  SDL_BlitSurface(bg,0,s,0);
  
  clearBloobfield(&bloobfield[0]);
  incSurfaceBloob(&bloobfield[0],image,100,100);
   
  incArrayBloob(&bloobfield[0],bloobCircle,(int)(200*sin(mtime/800.0))+250,40*(sin(mtime/300.0))+96);
  incArrayBloob(&bloobfield[0],bloobCircle,(int)(200*sin(1+mtime/800.0))+250,40*(sin(mtime/200.0))+96);
  incArrayBloob(&bloobfield[0],bloobCircle,(int)(200*sin(2+mtime/700.0))+250,40*(sin(mtime/200.0))+96);
  
      
  if(mtime < 5000) {
    blitBloobfield(150,150,0,0x560000,&bloobfield[0],s);
  } else {
    a = 150-(mtime-5000)/30.0;
    if(a<60) {a = 60;}    
     blitBloobfield(a,a,0,0x560000,&bloobfield[0],s);
    
    if(mtime > 6500) {
      blitString("skit i yttre rymden",200,230,s,font);
    }
    
    }  
}
