#include <SDL/SDL.h>

void blit3dLineObject(float k,int nPoints,float *x,float *y,float *z,int cx,int cy,int cz,SDL_Surface *s) {
  int i;
  int sx1,sy1;
  int sx2,sy2;
  float size;
  
  for(i=nPoints-1;i>=0;i-=2) {
    if(z[i]==-cz) z[i]++;
    size = k/(z[i]+cz);
    sx1 = size*x[i]+cx;
    sy1 = size*y[i]+cy;

    size = k/(z[i-11]+200);
    sx2 = size*x[i-1]+cx;
    sy2 = size*y[i-1]+cy;
    //    printf("%i %f %f %f %i %i\n",i,x[i],y[i],z[i],sx,sy);
    
    drawline(s,sx1,sy1,sx2,sy2,0xffffff);

  }
}


void blit3dPointObject(float k,int nPoints,float *x,float *y,float *z,int cx,int cy,int cz,SDL_Surface *s) {
  int i;
  int sx,sy;
  float size;
  
  for(i=nPoints-1;i>=0;i--) {
    if(z[i]==-cz) z[i]++;
    size = k/(z[i]+cz);
    sx = size*x[i]+cx;
    sy = size*y[i]+cy;
    //    printf("%i %f %f %f %i %i\n",i,x[i],y[i],z[i],sx,sy);
    
    putpixel(s,sx,sy,0xffffff);
    /*
    size = size*3+2;
    
      for(j=-size;j<size;j++) {
         putpixel(sx+j,sy,0xb0a000+abs(j)*10,s);
	 putpixel(sx,sy+j,0xb0a000+abs(j)*10,s);
	 putpixel(sx+j/2,sy+j/2,0x888888,s);
	 putpixel(sx-j/2,sy+j/2,0x888888,s);
	 
    }
    */
  }
}

void convert3dPointObject(float k,int nPoints,float *x,float *y,float *z,int *sx,int *sy,int cx,int cy,int cz) {
  int i;
  float size;
  
  for(i=nPoints-1;i>=0;i--) {
    if(z[i]==-cz) z[i]++;
    size = k/(z[i]+cz);
    sx[i] = size*x[i]+cx;
    sy[i] = size*y[i]+cy;
    //    printf("%i %f %f %f %i %i\n",i,x[i],y[i],z[i],sx,sy);
  }
}


void rotatePoint(float *px, float *py, float *pz,float ax,float ay,float az) {
  float x,y,z,ix,iy,iz;
  ix= *px;
  iy= *py;
  iz= *pz;
  /* z-rotation */
  if(az!=0) {
    x= ix;
    y= iy;
    z= iz;
    ix = x*cos(az)-y*sin(az);
    iy = x*sin(az)+y*cos(az);
  }
  
  /* x-rotation */
  if(ax!=0) {
    x= ix;
    y= iy;
    z= iz;
    iy= y*cos(ax)-z*sin(ax);
    iz= y*sin(ax)+z*cos(ax);
  }
  /* y-rotation */
  if(ay!=0) {
    x= ix;
    y= iy;
    z= iz;
    iz= z*cos(ay)-x*sin(ay);
    ix= z*sin(ay)+x*cos(ay);
  }
  *px = ix;
  *py = iy;
  *pz = iz;
  
}
