#include <SDL/SDL.h>
#include <stdio.h>

/* message from buzz-: if you read this source you are a communist */

float sintab[256];
float costab[256];

/* the sin-table isn't really 2d-graphics, but it didn't fit in any other file */
void fillSintab() {
  int i;
  for(i=0;i<256;i++) {
    sintab[i] = sin((float)i/255*2*M_PI);
    costab[i] = cos((float)i/255*2*M_PI);
  }
}

inline void putpixel(SDL_Surface *s,int x, int y, int color) {
  int *p = s->pixels;
  if(x>0) if(y>0) if(x<s->w) if(y<s->h)
    p[x+y*s->w] = color;
}

void drawline(SDL_Surface *screen, int x1, int y1, int x2, int y2, Uint32 color){

  int deltax,deltay;
  int x, y;
  int yinc2,den,num,numadd,numpixels,yinc1,xinc1,xinc2,curpixel;

  
  deltax = abs(x2 - x1);        
  deltay = abs(y2 - y1);        
  x = x1;                       
  y = y1;                       
  
  if (x2 >= x1)                 
    {
      xinc1 = 1;
      xinc2 = 1;
    }
  else                          
    {
      xinc1 = -1;
      xinc2 = -1;
    }
  
  if (y2 >= y1)                 
    {
      yinc1 = 1;
      yinc2 = 1;
    }
  else                          
    {
      yinc1 = -1;
      yinc2 = -1;
    }
  
  if (deltax >= deltay)         
    {
      xinc1 = 0;                
      yinc2 = 0;                
      den = deltax;
      num = deltax / 2;
      numadd = deltay;
      numpixels = deltax;       
    }
  else                          
    {
      xinc2 = 0;                 
      yinc1 = 0;                 
      den = deltay;
      num = deltay / 2;
      numadd = deltax;
      numpixels = deltay;        
    }
  
  for (curpixel = 0; curpixel <= numpixels; curpixel++)
    {
      putpixel(screen,x,y,color);
      num += numadd; 
      if (num >= den)
	{
	  num -= den;
	             
	  x += xinc1;
	  y += yinc1;
	}
      x += xinc2; 
      y += yinc2; 
    }
}

SDL_Surface *screenShot(SDL_Surface *s) {
  /*fungerar bara nstan, men kanske inte behvs heller */
  /* s r samma som t nr funktionen r klar av nn anledning */

  /*
  SDL_Surface *n;
  SDL_Surface *t;
  n = SDL_CreateRGBSurface(s->flags,s->w,s->h,s->format->BitsPerPixel,
		    s->format->Rmask,s->format->Gmask,s->format->Bmask,
		    s->format->Amask);
  t =s;
  s = n;
  return t;
  */

}


Uint32 getpixel2ARGB(SDL_Surface *surface, int x, int y) {
  SDL_PixelFormat *fmt;
  Uint32 temp;
  Uint32 *pixel;
  Uint8 red, green, blue, alpha;
  int offset = x + y*surface->w;
  
  fmt=surface->format;
  pixel=surface->pixels;
  
  
  /* Get Red component */
  temp=pixel[offset]&fmt->Rmask; /* Isolate red component */
  temp=temp>>fmt->Rshift;/* Shift it down to 8-bit */
  temp=temp<<fmt->Rloss; /* Expand to a full 8-bit number */
  red=(Uint8)temp;
  
  /* Get Green component */
  temp=pixel[offset]&fmt->Gmask; /* Isolate green component */
  temp=temp>>fmt->Gshift;/* Shift it down to 8-bit */
  temp=temp<<fmt->Gloss; /* Expand to a full 8-bit number */
  green=(Uint8)temp;
  
  /* Get Blue component */
  temp=pixel[offset]&fmt->Bmask; /* Isolate blue component */
  temp=temp>>fmt->Bshift;/* Shift it down to 8-bit */
  temp=temp<<fmt->Bloss; /* Expand to a full 8-bit number */
  blue=(Uint8)temp;
  
  /* Get Alpha component */
  temp=pixel[offset]&fmt->Amask; /* Isolate alpha component */
  temp=temp>>fmt->Ashift;/* Shift it down to 8-bit */
  temp=temp<<fmt->Aloss; /* Expand to a full 8-bit number */
  alpha=(Uint8)temp;
  
  return alpha<<24 | red<<16 | green<<8 | blue;
  
}
void ring(SDL_Surface *screen,int x,int y, int radie, Uint32 color){
  int i;
  for(i=0;i<=(radie*16);i++){
    
    putpixel(screen,(float)cos(i)*radie+x,(float)sin(i)*radie+y,color);
    
  }
}
void hring(SDL_Surface *screen,int x,int y, int radie1,int radie2, Uint32 color){
  int i;
  for(i=0;i<=(radie1*16);i++){
    
    putpixel(screen,(float)cos(i)*radie1+x,(float)sin(i)*radie2+y,color);
    putpixel(screen,(float)cos(i)*(radie1-1)+x,(float)sin(i)*(radie2-1)+y,color);
    putpixel(screen,(float)cos(i)*(radie1-2)+x,(float)sin(i)*(radie2-2)+y,color);
 
  }
}

void blitScaleDown(SDL_Surface *screen, SDL_Surface *image, float scale,int sx, int sy) {
  Uint32 color;
  float x,y;
  Uint32 *dstp;
  dstp = image->pixels;
  //  printf("%i %i\n",screen->format->BitsPerPixel,image->format->BitsPerPixel);
  sx-=image->w/2/scale;
  sy-=image->h/2/scale;
  float xx,yy;

  yy=0;
  for(y=0;y<image->h;y+=scale) {
    yy++;
    if(sy+yy >= screen->h) return;
    if(sy+yy>0) {
      xx =0;
      for(x=0;x<image->w;x+=scale) {
	xx++;
	if(sx+xx>0) if(sx+xx<screen->w) {
	  color = getpixel2ARGB(image,x,y);
	  if(color!=image->format->colorkey) { 
	    putpixel(screen,(int)(sx+xx),(int)(sy+yy),color);	  
	  }
	}
      }
    }
  }
}
