#include "window.h"
#include "fyll.h"

#include <GL/glut.h>
#include <GL/glx.h>
#include <X11/extensions/xf86vmode.h>
#include <X11/keysym.h>
#include <unistd.h>


Display *display;
int screen;
XF86VidModeModeInfo deskmode;
		
window::window() {
	
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
	glutInitWindowPosition(0,0);
	
	if(!FULLSCREEN) {
		glutInitWindowSize(XRES, YRES);
		windowid = glutCreateWindow(WINDOWTITLE);
	}
	else {

		glutInitWindowSize(XRES+20, YRES+20);
		windowid = glutCreateWindow(WINDOWTITLE);
		
		// ripped from Sesse's demolib. thankye (: [and fucked up by me]

		XF86VidModeModeInfo bestmode;
		XF86VidModeModeInfo **modes;
		int bestmodeid;
		int modeNum;
		int height = 0, width = 0;
		

		display = XOpenDisplay(0);
		screen = DefaultScreen(display);
		
		XF86VidModeGetAllModeLines(display, screen, &modeNum, &modes);

		deskmode = *modes[0];
		bestmode = deskmode;

		for( int i = 0; i < modeNum; i++) {
			if((modes[i]->hdisplay >= width)
					&& (modes[i]->hdisplay < bestmode.hdisplay)
					&& (modes[i]->vdisplay >= height + 1)
					&& (modes[i]->vdisplay < bestmode.vdisplay))
			{
				bestmode = *modes[i];
				bestmodeid = i;
			}
			dprint("mode: " << i << " x: " << modes[i]->hdisplay << " y: " << modes[i]->vdisplay << '\n');
		}

		dprint("best mode: " << bestmodeid << " x: " << bestmode.hdisplay << " y: " << bestmode.vdisplay << '\n');
		
		XWarpPointer(display, None, DefaultRootWindow(display), 0, 0, 0, 0, 50, 50);
		XF86VidModeSwitchToMode(display, screen, modes[bestmodeid]);

		XF86VidModeSetViewPort(display, screen, 20, 30);
		XWarpPointer(display, None, DefaultRootWindow(display), 0, 0, 0, 0, 640+20, 480+30);
		XFree(modes);
		XFlush(display);
					
	}

	setclearcolor(0.0, 0.0, 0.0);
}

window::~window() {
	if(FULLSCREEN) {
		glutDestroyWindow(windowid);
		dprint("desktop mode:  x: " << deskmode.hdisplay << " y: " << deskmode.vdisplay << '\n');
		XF86VidModeSwitchToMode(display, screen, &deskmode);
		XF86VidModeSetViewPort(display, screen, 0, 0);
		XFlush(display);
	}
	else glutDestroyWindow(windowid);
}

void window::resize(int x, int y) {

	dprint("resize x: " << x << " y: " << y <<'\n');

	if(!x) x++;
	if(!y) y++;

	width = x;
	height = y;

	glViewport(0, 10, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);
}

void window::draw() {
}

void window::predraw() {
	glClearColor(clear[R], clear[G], clear[B], clear[A]);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

void window::postdraw() {
	glutSwapBuffers();
}

void window::setclearcolor(float r, float g, float b, float a) {
	clear[R] = r;
	clear[G] = g;
	clear[B] = b;
	clear[A] = a;
}

void window::setclearcolor(float r, float g, float b) {
	clear[R] = r;
	clear[G] = g;
	clear[B] = b;
	clear[A] = 1.0;
}
