#include "roachintro.h"
#include "fyll.h"
#include "window.h"
#include "demo.h"

#include <GL/gl.h>
#include <GL/glut.h>
#include <math.h>
#include <cstdlib>

#include "dassrull.h"
#include "hamstertop.h"
#include "rass.h"
#include "rasstex.h"

roachintro::roachintro() {
	this->starttime = 220;
	this->endtime = 1700;
	this->mytex = new texture(DASSRULL_DATA, DASSRULL_LEN, true, GL_LUMINANCE);
	this->hamstertop = new texture(HAMSTERTOP_DATA, HAMSTERTOP_LEN, true, GL_RGB);
	this->rasstex = new texture(RASSTEX_DATA, RASSTEX_LEN, true, GL_RGB);
	scrolltext = strdup("> > > ROACHINTRO ! N\001 skal vi l\002re \001 roache! Vi trenger:  en DASSRULL.  en HAMSTER.  rassh\007let DITT.  > > > Demonstrasjon f\007lger! > > >");
	scroller = new Text( demo::fnt, scrolltext);
	demo::blur = true;
}

roachintro::~roachintro() {
	delete mytex;
	free(scrolltext);
	delete scroller;
}

void roachintro::init() {
	w->setclearcolor(1.0, 0.5, 0.6);
	demo::blurscene->set_zoom(0.03);
	demo::blurscene->set_level(5);
	init_rass();
}

void roachintro::cleanup() {
}

void roachintro::draw() {
	
	if(sleeping()) return;

	float scenetime = demo::time - starttime;

	float scenelen = starttime - endtime;
	
	if(scenetime > 700 && scenetime < 800) {
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		glBindTexture(GL_TEXTURE_2D, mytex->get_num());
		glColor3f(1.0, 1.0, 1.0);
		glPushMatrix();
		glTranslatef(-1.0, 1.0, -5.0);
		glRotatef(scenetime, 0.0, 1.0, 0.0);
		glScalef(0.5, 0.5, 0.5);
		glBegin(GL_QUAD_STRIP); 
		for(float i = 0.0; i < 2*M_PI+0.1; i += 0.1) {
			glNormal3f(sin(i), cos(i), 0.2);
			glTexCoord2f((i)/ (2*M_PI), 0.0);
			glVertex3f(sin(i), cos(i), -1.5);
			glTexCoord2f((i)/ (2*M_PI), 1.0);
			glVertex3f(sin(i), cos(i), 1.5);
		}
		glEnd();
		glPopMatrix();
		glDisable(GL_TEXTURE_2D);
		glEnable(GL_LIGHTING);
	}

	if(scenetime > 800 && scenetime < 1000 && !demo::blurring) {
		glPushMatrix();
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, hamstertop->get_num());
		glTexGenf(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGenf(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGenf(GL_R, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGenf(GL_Q, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);
	
		glColor4f(0.3, 0.1, 0.0, 0.9);
		glTranslatef(0.0, 0.0, -5.0); // move back
		
		//movement:
	
		float skraa;
		skraa = 6.0 - (scenetime-800)/20;
	/*	} else if (scenetime < 1000) {
			skraa = 6.0 - 1/20;
		} else {
			skraa = 6.0 - (scenetime-950);
		}*/
		glTranslatef(skraa, skraa-1, 0.0);
		
		//rotation:
		glRotatef(45, 0.0, 0.0, 1.0);
		//glScalef(0.4, 0.4, 0.05);
		//glRotatef(90, 1.0, 0.0, 0.0);
		glutSolidSphere(1.0, 20, 10);
		
		glDisable(GL_TEXTURE_GEN_T);
		glDisable(GL_TEXTURE_GEN_S);
		glDisable(GL_TEXTURE_2D);
		glPopMatrix();
	}
	if(scenetime > 1000 && scenetime < 1300 && !demo::blurring) {
		glPushMatrix();
		glTranslatef((scenetime-1000)/15-6, 1, -5.0);
		glTranslatef(0, 1, -5.0);
		glScalef(0.4, 0.4, 0.2);
		glRotatef(10, 1.0, 0.0, 0.0);
		glBindTexture(GL_TEXTURE_2D, rasstex->get_num());
		draw_rass();
		glPopMatrix();
	}
	// scroller
	glPushMatrix();
	glScalef(0.3, 0.3, 1.0);
	vector v = {-((float)demo::time-starttime)/9, -2.0, -2.0};
	scroller->set_pos(v);
	for(int i = 0; i < strlen(scrolltext); i++) {
		scroller->set_aksepos(Y, (cos((2*M_PI*scenetime)/scenelen) + 1.2)*1.2*(sin((double)i/2)/3) - 1.0 );
		scroller->draw(i);
	}
	glPopMatrix();
}
