#include "gl.h"
#include "fyll.h"
#include "window.h"
#include "demo.h"

window *w;

void gl::init(int &argc, char **argv) {
	dprint("gl::init()\n");
	
	glutInit(&argc, argv);
	
	w = new window();
	glutReshapeFunc(&gl::resize);
	glutDisplayFunc(&demo::doframe);
	glutIdleFunc(&demo::doframe);
	glutKeyboardFunc(&demo::keypressed);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	w->resize(XRES, YRES);
	dprint("hei");
}

void gl::resize(int x, int y) {
	dprint("gl::resize()\n");
	w->resize(x, y);
}

void gl::predraw() {
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	w->predraw();
	return;
}

void gl::draw() {
	w->draw();
	return;
}

void gl::postdraw() {
	w->postdraw();
	return;
}

void gl::run() {
	glutMainLoop();
}

