#include "blur.h"

#include <cstring>

#include "fyll.h"

const int blur_s = 64;

Blur::Blur() {

	level = 5;
	zoom = 0.034;
	
	// make empty texture
	unsigned int* data;
	data = (unsigned int*) new GLuint[128*128*4*sizeof(unsigned int)];
	memset(data, 0, blur_s*blur_s*4*sizeof(unsigned int));
	
	glGenTextures(1, &blurtex);

	glBindTexture(GL_TEXTURE_2D, blurtex);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, blur_s, blur_s, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	delete[] data;
}

void Blur::init_blur() {
	glClearColor(0.0, 0.0, 0.0, 1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glViewport(0, 0, blur_s, blur_s);
}

void Blur::end_blur() {
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, blurtex);
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, blur_s, blur_s, 0);
	w->predraw();
	glViewport(0, 0, 660, 480);
	glDisable(GL_TEXTURE_2D);
}

void Blur::draw_blur() {
	
	// ortho view
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0, 640, 480, 0, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();  // ja, push. ja.
	glLoadIdentity();
	
	// from nehe (:

	float spost = 0.0;
	float alpha = 0.2;
	float alphainc = alpha / level;

	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glEnable(GL_BLEND);

	glBindTexture(GL_TEXTURE_2D, blurtex);
	
	glBegin(GL_QUADS); {
		for(int i = 0; i < level; i++) {
			glColor4f(1.0, 1.0, 1.0, alpha);

			glTexCoord2f(0+spost, 1-spost);
			glVertex2f(0.0, 0.0);

			glTexCoord2f(0+spost, 0+spost);
			glVertex2f(0.0, 480.0);

			glTexCoord2f(1-spost, 0+spost);
			glVertex2f(640.0, 480.0);

			glTexCoord2f(1-spost, 1-spost);
			glVertex2f(640.0, 0.0);

			spost += zoom;
			alpha -= alphainc;
		}
	} glEnd();

	
	// default view
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glEnable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glBindTexture(GL_TEXTURE_2D, 0);
	
}
