//
// Fur effect using shells and fins
//
// Note: This effect file does not work with EffectEdit.
//
#define C_ZERO              0 
#define C_ONE               1 
#define C_HALF              2 
#define C_MATTOTAL          4 
#define C_MATWORLD          8
#define C_TICKS             31
#define C_TICKS2             34
#define C_SPHERE_CENTER       40
#define C_SPHERE_RADIUS       41
#define C_SPHERE_PERCENT       42




float1 Ticks=111.0f;
float1  Tape_Factor=1.1f;
float1  Tape_Shift=1.0f;


// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

// eye position
float3 Eye;
float4x4 Mat_Total;

float3 Ticks2=float3(1.0f, 1.0f, 1.0f);

float4 SPHERE_CENTER=float4(1.0f,011.0f,1.0f,0.0f);
float1 SPHERE_RADIUS=1.0f;
float1 SPHERE_PERCENT=1.0f;


static const float4 vOne = float4(1, 1, 1, 1);

// vertex shaders

// sampler
sampler ClampedLinear =
sampler_state
{
    Texture   = NULL;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// techniques
technique Init
{
    pass P0
    {
        // render states
        CullMode = NONE;

        AmbientMaterialSource = COLOR1;
        DiffuseMaterialSource = COLOR1;

        BlendOp   = ADD;
        SrcBlend  = SRCALPHA;
        DestBlend = INVSRCALPHA;

        AlphaTestEnable = FALSE;
        AlphaFunc       = GREATER;
        AlphaRef        = 0;

        AlphaBlendEnable = TRUE;

        // texture stage states
        AlphaOp[0]   = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = CURRENT;

        // sampler
        Sampler[0]  = (ClampedLinear);


        Lighting = FALSE;

        // vertex shader constants
        VertexShaderConstantF[C_ZERO]              = (0.0f * vOne);
        VertexShaderConstantF[C_ONE]               = (1.0f * vOne);
        VertexShaderConstantF[C_HALF]              = (0.5f * vOne);
       
        // transforms
        ViewTransform       = (View);
        ProjectionTransform = (Projection);
    }
}


struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float3 Diff : COLOR0;
    float3 Tex0 : TEXCOORD0 ;
};



VS_OUTPUT Spherical_X(
    float3 Pos  : POSITION,
    float3 Norm : NORMAL,
    float3 Diff : COLOR0 ,

    float3 Tex : TEXCOORD0
  )
    {
    VS_OUTPUT Out = (VS_OUTPUT)0;

     float3 Point=Pos;

    float3 Center=C_SPHERE_CENTER;
    float1 xw= Pos.x-Center.x;
    float1 yw= Pos.y-Center.y;
    float1 zw= Pos.z-Center.z;
    all(xw);
     all(yw);
    all(zw);
   // all(Point_Delta);

     float  vdist= sqrt(xw*xw+yw*yw+zw*zw);
     float   mfac=C_SPHERE_RADIUS/vdist;


        float dx = xw+sign(xw)*(float(abs(xw*mfac)- abs(xw))*C_SPHERE_PERCENT);
	float dy = yw+sign(yw)*(float(abs(yw*mfac)- abs(yw))*C_SPHERE_PERCENT);
	float dz = zw+sign(zw)*(float(abs(zw*mfac)- abs(zw))*C_SPHERE_PERCENT);

       Point.x=dx+Center.x;
       Point.y=dy+Center.y;
       Point.z=dz+Center.z;
 float4 P2  = mul(float4(Pos, 1), Mat_Total );             // position (projected)


      Out.Pos=P2;
     Out.Tex0 =Tex;
     Out.Diff=float3(1,1,1);
    return Out;
}


technique Twist
{
    pass P0
    {

        // render states
        AlphaTestEnable  = TRUE;

        // texture

        // vertex shader
       // VertexShader = (ShellVS);

   //    VertexShader = compile vs_1_1 Twist_X();
    VertexShader = compile vs_1_1 Spherical_X();

          VertexShaderConstantF[C_MATTOTAL]      = (mul(mul(World, View), Projection));
        VertexShaderConstantF[C_MATWORLD]      = (World);

        VertexShaderConstantF[C_TICKS]      = (Ticks);
        VertexShaderConstantF[C_SPHERE_CENTER]      = (SPHERE_CENTER);
        VertexShaderConstantF[C_SPHERE_RADIUS]      = (SPHERE_RADIUS);
        VertexShaderConstantF[C_SPHERE_PERCENT]      = (SPHERE_PERCENT);
        VertexShaderConstantF[C_TICKS2]      = (Ticks2);
         VertexShaderConstantF[C_TICKS2]      = (Ticks2);



    }
}
