	SECTION "twistbar", HOME

twpal	set	rampage1

twistbar::
	START_MUSIC_INT

	ld	de, $0700
	call	flush

	ROMBANK	data2

	ld	a, 1
	ld	[rVBK], a
	ld	hl, _SCRN0
	ld	a, 0
	ld	bc, 1024
	call	vmemset
	xor	a
	ldh	[rVBK], a

	ld	a, 32
	ld	hl, _SCRN0
	ld	bc, 32*4
	call	vmemset
	xor	a
	ld	bc, 8<<8+4
	ld	hl, _SCRN0
	call	makemap

	ld	hl, twist_tiles
	ld	de, _VRAM
	ld	bc, 65*16
	call	vmemcopy

	ld	hl, twist_barcolours
	ld	de, twpal
	ld	bc, 32*4
	call	vmemcopy
	
	; do sprites
	ld	hl, twist_oamdata
	ld	de, oambuf
	ld	b, 160
	call	memcpsh

	xor	a
	ld	hl, ylist
	ld	b, 144
	call	memstsh

	ld	hl, twist_barcolours
	ld	de, twpal
	ld	bc, 32*4
	call	memset

	ld	a, -12
	ld	[counter], a

	ld	b, 8
	ld	hl, twist_bgpal
	call	setbgpal
	ld	b, 8
	ld	hl, twist_fgpal
	call	setobpal

	di
	ld	de, twist_irq
	call	setlcdcirq
	ld	a, %01000000
	ldio	[rSTAT], a
	ei

	ld	a, %10010111
	ldio	[rLCDC], a

	ld	b, 140
twistin	push	bc
	MusicUpdate musicb
	ROMBANK	mathb
	pop	bc
	ld	a, -40
	sub	a, b
	ldio	[rSCX], a
	xor	a
	ld	[rLYC], a
	push	bc
	call	intwist
	call	logomov
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	ld	hl, counter
	inc	[hl]
	pop	bc
	djnz	twistin

twistn2	MusicUpdate musicb
	ROMBANK	mathb
	xor	a
	ld	[rLYC], a
	call	intwist
	call	logomov
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	ldh	a, [counter]
	inc	a
	and	63
	ldh	[counter], a
	jr	nz, twistn2

twist_main
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	MusicUpdate musicb
	ROMBANK	mathb
	ld	hl, counter
	inc	[hl]
	xor	a
	ld	[rLYC], a
	call	twist
	ldh	a, [counth]
	cp	time+2
	jr	nz, twist_main

	ld	b, 110
twistut	push	bc
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	MusicUpdate musicb
	ROMBANK	mathb
	ld	hl, counter
	inc	[hl]
	xor	a
	ld	[rLYC], a
	call	twist
	call	logom0v
	ld	hl, rSCX
	inc	[hl]
	pop	bc
	djnz	twistut
	;ldh	a, [counth]
	;cp	time+3
	;jr	nz, twistut

	ret

twist_irq
	PUSHA
	
	ldio	a, [rLYC]
	ld	l, a
	ld	h, ylist >> 8
	sub	[hl]
	cpl
	inc	a
	ldio	[rSCY], a
	
	;push	hl
	;ld	hl, countl
	;ldio	a, [rLYC]
	;add	a, [hl]
	;ld	h, sintab >> 8
	;ld	l, a
	;ld	a, [hl]
	;sra	a
	;sra	a
	;ld	b, a
	;ldh	a, [delta]
	;add	a, b
	;ldio	[rSCX], a
	;pop	hl
	
	inc	l
	ld	a, [hl]
	add	a, a
	add	a, a
	ld	l, a
	ld	h, twpal >> 8
	ld	a, $82
	ld      [rBCPS], a
	ld	c, rBCPD & 255
	VRWAIT
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a

.done	ldio	a, [rLYC]
	inc	a
	ldio	[rLYC], a

	POPA
	reti

logomov	ld	hl, oambuf
	ld	a, [hl]
	cp	124
	ret	z
	ld	b, 16
.loop	dec	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret

logom0v	ld	hl, oambuf+1
	ld	a, 168
	cp	[hl]
	ret	z
	ld	b, 16
.loop	inc	[hl]
	inc	l
	inc	l
	inc	l
	inc	l
	djnz	.loop
	ret

twist	ld	b, 144
	ld	de, ylist
	ld	h, sintab >> 8
.loop	ldh	a, [counter]
	add	a, b
	ld	l, a
	ld	a, [hl]
	sra	a
	ld	c, a
	ldh	a, [counter]
	sub	b
	ld	l, a
	ld	a, [hl]
	sra	a
	add	a, c
	sra	a
	ld	c, a
	ld	a, [counter]
	add	a, c
	and	31
	ld	[de], a
	inc	de
	dec	b
	jr	nz, .loop
	ret

intwist	ld	b, 144
	ldh	a, [counter]
	and	31
	ld	hl, ylist
	ld	b, 144
	jp	memstsh

	SECTION	"twist data", DATA, BANK[data2]

twist_tiles
	INCBIN	"twistbar.tls"
	INCBIN	"oct-logo.tls"
	DB	$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00

; DB A=(129-255)		write A-128 bytes increasing counter
; DB A=(1-127),B=(0-255)	write A bytes of value B
; DB 128,A			set counter to A
; DB 0				end of map

twist_map
	;db	128, 0
	;rept	4
	;db	128+8, 24, 64
	;endr
	;db	0

twist_fgpal
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$07, $07, $07
	DW_RGB	$1f, $1f, $1f

twist_bgpal
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$07, $07, $07
	DW_RGB	$1f, $1f, $1f
	
twist_barcolours
shade	SET	0
	REPT	32
	DW_RGB	31-shade, 31-shade, 0
	DW_RGB	shade, shade, 0
shade	SET shade+1
	ENDR

twist_oamdata
t	set	32
x	set	98
y	set	124+64
	rept	8
	db	y, x, t, 0
	db	y+16, x, t+16, 0
x	set	x+8
t	set	t+2
	endr
	rept	40-8
	db	0,0,0,0
	endr
	
time	set	time+3