;********************************************************************************

; cls fr ett bitplan
clsa	ld	b, 32
	xor	a
.loop	REPT	64
	ld	[hl+], a
	inc	l
	ENDR
	dec	b
	jp	nz, .loop
	ret

clsb	ld	b, 32
clsb2	xor	a
.loop	REPT	64
	ld	[hl+], a
	inc	hl
	ENDR
	dec	b
	jp	nz, .loop
	ret

; total cls
tcls	ld	b, 64
tcls2	xor	a
.loop	REPT	64
	ld	[hl+], a
	ENDR
	dec	b
	jp	nz, .loop
	ret

qcls	xor	a
	ld	c, 8
.loop2	ld	b, 4
.loop1	REPT	32
	ld	[hl+], a
	ENDR
	djnz	.loop1
	inc	h
	ld	l, 0
	dec	c
	jr	nz, .loop2
	ret

cp_cls	ld	a, $ff
	ld	c, 4
.loop2	ld	b, 4
.loop1	REPT	16
	ld	[hl+], a
	ENDR
	djnz	.loop1
	inc	h
	ld	l, 0
	dec	c
	jr	nz, .loop2
	ret

;********************************************************************************

	; plot pixel (d=x,e=y) at $8000
plot80	sla	e		;  8
	ld	a, d		;  4
	sra	d		;  8
	sra	d		;  8
	sra	d		;  8
	set	7, d		;  8
	and	7		;  8
	ld	l, a		;  4
	ld	h, 0		; (8)
	ld	a, [de]		;  8
	xor	[hl]		;  8
	ld	[de], a		;  8
	ret

;********************************************************************************

	; plot pixel (d=x,e=y) at $d000
plot	ld	a, d
	ld	c, d
	sla	e
	sra	a
	sra	a
	sra	a
	add	a, $d0
	ld	d, a
	ld	a, c
	and	7
	ld	l, a
	inc	e
	ld	h, 0
	ld	a, [de]
	or	[hl]
	ld	[de], a
	ret

cplot	ld	a, d
	ld	c, d
	sla	e
	sra	a
	sra	a
	sra	a
	add	a, $d0
	ld	d, a
	ld	a, c
	and	7
	ld	l, a
	inc	e
	ld	h, 0
	ld	a, [de]
	cpl
	or	[hl]
	cpl
	ld	[de], a
	ret

;********************************************************************************

	; xor fill 1bpl top->down

xorfill	ld	hl, $d001
	ld	b, 16
xorfil2	ld	d, l
.loop	ld	a, [hl+]
	REPT	127
	inc	l
	xor	[hl]
	ld	[hl+], a
	ENDR
	ld	l, d
	dec	b
	;bit	4, h
	jp	nz, .loop
	ret

;********************************************************************************	

qxorfil	ld	b, 8
	ld	c, l
.loop	ld	a, [hl+]
	REPT	63
	inc	l
	xor	[hl]
	ld	[hl+], a
	ENDR
	inc	h
	ld	l, c
	dec	b
	jp	nz, .loop
	ret
	
;********************************************************************************	

horiz	xor	a
	sub	d
	;inc	b ; |dx|+1
.loop	ldh	[alpha], a
	ld	a, c
	or	[hl]
	ld	[hl], a
	rrc	c
	jr	nc, .SameB
	inc	h
.SameB	ldh	a, [alpha]
	add	a, e ;|dy|
	jr	nc, .SameY
	inc	l
	inc	l
	sub	d ;|dx|
.SameY	dec	b
	jr	nz, .loop
	ret

vert	xor	a
	sub	e
	ld	b, e
	;inc	b ; |dy|+1
.loop	ldh	[alpha], a
	ld	a, c
	or	[hl]
	ld	[hl], a
	ldh	a, [alpha]
	add	a, d ;|dx|
	;ldh	[alpha], a
	jr	nc, .SameX
	rrc	c
	jr	nc, .SameB
	inc	h
.SameB	;ldh	a, [alpha]
	sub	e ;|dy|
.SameX	inc	l
	inc	l
	dec	b
	jr	nz, .loop
	ret

initline
	ld	hl, horiz
	ld	de, $ffa0
	ld	bc, vert-horiz
	call	memcopy
	ld	hl, vert
	ld	de, $ffc0
	ld	bc, initline-vert
	call	memcopy
	ret

xhoriz	xor	a
	sub	d
.loop	ldh	[alpha], a
	ld	a, c
	xor	[hl]
	ld	[hl], a
	rrc	c
	jr	nc, .SameB
	inc	h
.SameB	ldh	a, [alpha]
	add	a, e ;|dy|
	jr	nc, .SameY
	inc	l
	inc	l
	sub	d ;|dx|
.SameY	dec	b
	jr	nz, .loop
	ret

xvert	xor	a
	sub	e
	ld	b, e
.loop	add	a, d ;|dx|
	ldh	[alpha], a
	jr	nc, .SameX
	ld	a, c
	xor	[hl]
	ld	[hl], a
	rrc	c
	jr	nc, .SameB
	inc	h
.SameB	ldh	a, [alpha]
	sub	e ;|dy|
.SameX	inc	l
	inc	l
	dec	b
	jr	nz, .loop
	ret

initline_xor
	ld	hl, xhoriz
	ld	de, $ffa0
	ld	bc, xvert-xhoriz
	call	memcopy
	ld	hl, xvert
	ld	de, $ffc0
	ld	bc, initline_xor-xvert
	call	memcopy
	ret

	; draw a line from (d,e) to (h,l)
	; carry flag indicates bitplane

line	push	af
	
	ld	a, h
	sub	d
	jr	nc, .dxok
	neg
	ld	b, e
	ld	d, h
	ld	e, l
	ld	l, b
.dxok	ld	b, a		; save |dx| in b

	ld	h, $2c ; inc h

	ld	a, l
	sub	e
	jr	nc, .dyok
	neg
	;ld	h, $2d ; dec h
	inc	h
.dyok	ld	c, a		; save |dy| in c

	; modify the code
	ld	a, h
	ld	[$ff00+$b1], a
	ld	[$ff00+$b2], a
	ld	[$ff00+$d3], a
	ld	[$ff00+$d4], a
	;sub	$2c
	;swap	a
	;add	a, $22
	;ld	[$ff00+$db], a

	pop	af

	; ** Find startposition in memory and get pixel mask
	ld	a, d
	ld	h, d
	rl	e
	sra	a
	sra	a
	sra	a
	add	a, $d0
	ld	d, a
	ld	a, h
	and	7
	ld	l, a
	ld	h, 0
	ld	a, [hl]	; a now holds the first pixel mask

	; ** Set some registers
	ld	h, d
	ld	l, e
	ld	d, b	; |dx|
	ld	e, c	; |dy|
	ld	c, a	; pixel mask

	ld	a, d		; |dx|
	cp	e		; |dy|

	jp	c, $ffc0	; |dx| < |dy|
	jp	$ffa0

;********************************************************************************	
