	SECTION "butterfly", HOME

pipelup	set	rampage1

butterfly
	START_MUSIC_INT
	
	call	clearsprites
	ld	de, $4210
	call	flush
	
	ROMBANK	data2

	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0+18*32
	ld	bc, 14*32
	call	vmemset
	ld	hl, btrfly_tiles+256*16
	ld	de, _VRAM
	ld	bc, 104*16
	call	vmemcopy
	ld	de, btrfly_amap
	ld	hl, _SCRN0
	ld	bc, 20<<8+18
	call	drawmap

	xor	a
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 20<<8+18
	call	makemap
	ld	hl, btrfly_tiles
	ld	de, _VRAM
	ld	bc, 256*16
	call	vmemcopy

	ld	hl, _SCRN0+18*32
	ld	bc, 14*32
	ld	a, $9a
	call	vmemset

	ld	hl, tube
	ld	de, pipelup
	ld	bc, 64
	call	memcopy

	ld	a, 144
	ld	b, 144
	ld	hl, ylist
	call	memstsh
	
	ld	a, -40
	ldh	[counter], a	
	xor	a
	ldio	[rSCX], a

	ld	b, 64
	ld	hl, btrfly_pal
	call	setbgpal

	ld	de, btrfly_irq
	call	setlcdcirq
		
	ld	a, %01000000
	ldio	[rSTAT], a
	ld	a, %10010111
	ldio	[rLCDC], a

btrfly_main
	waitVBL
	MusicUpdate musicb
	
	xor	a
	ld	[rLYC], a
	
	call	roll

	ld	hl, counter
	ldh	a, [counth]
	cp	time+0
	jr	nz, .skip1
	inc	[hl]
.skip1	cp	time+2
	jr	nz, .skip2
	dec	[hl]
.skip2
	ldh	a, [counth]
	cp	time+3
	jr	nz, btrfly_main

	ld	a, 1
	ldio	[rVBK], a
	xor	a
	ld	hl, _SCRN0
	ld	bc, 1024
	call	memset
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	call	memset

	ret

roll	ld	h, ylist>>8
	ld	de, pipelup+64
	ldh	a, [counter]
	ld	l, a
	ldh	a, [counter]
	ld	c, a
	ld	b, 32
.loop	ld	a, [de]
	srl	a
	dec	e
	dec	e
	add	a, c
	cp	144
	jr	c, .ok
	ld	a, l
.ok	ld	[hl], a
	inc	l
	djnz	.loop
	ldh	a, [counter]
	ld	l, a
	ld	[hl], a
	ld	a, l
	add	a, 32
	ld	l, a
	ld	[hl], 144
	ret
	
btrfly_irq
	push	af
	push	hl
	ldio	a, [rLYC]
	inc	a
	ldio	[rLYC], a
	dec	a
	ld	l, a
	ld	h, ylist >> 8
	sub	[hl]
	neg
	ldio	[rSCY], a
	pop	hl
	pop	af
	reti


	SECTION "butterfly picture", DATA, BANK[data2]

btrfly_amap	incbin	"btrfly.atr"
btrfly_tiles	incbin	"btrfly.tls"
btrfly_pal	incbin	"btrfly.pal"

tube	DB $20,$2D,$36,$3E,$45,$4B,$50,$55,$59,$5D,$61,$64,$67,$6A,$6C,$6F
	DB $71,$73,$75,$77,$78,$7A,$7B,$7C,$7D,$7E,$7E,$7F,$7F,$80,$80,$80
	DB $80,$80,$80,$81,$81,$82,$82,$83,$84,$85,$86,$88,$89,$8B,$8D,$8F
	DB $91,$94,$96,$99,$9C,$9F,$A3,$A7,$AB,$B0,$B5,$BB,$C2,$CA,$D3,$E0
	
time	set	time+3