
/* gcc bp-rain-note.c `sdl-config --libs` -lSDL_image -Wall -o bp-rain-note */

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <string.h>

#define ANTAL_RIPPLE 5
#define FONTH 22
#define FONTW 16
#define FONTMAPH 198
#define MAXBOK 40


float sintab[256];
float costab[256];


typedef struct {
  int x;
  int y;
  float freq;
  float v;
  float maxl;
  float mtid;
  //  int mtops;
  int tops;
  Uint32 stid;
} ripstr ;


void putpixel(SDL_Surface *screen,int x,int y,Uint32 c) {
  Uint32 *pp = screen->pixels;
  if(x>0)if(x<screen->w)if(y>0)if(y<screen->h)
    pp[x+y*screen->w]=c;
}

void incpixel(SDL_Surface *screen,int x,int y,unsigned char r,unsigned char g,unsigned char b) {
  Uint32 *pp = screen->pixels;
  int tmpr=0,tmpg=0,tmpb=0;
  if(x>0)if(x<screen->w)if(y>0)if(y<screen->h) {
    tmpr = r+((pp[x+y*screen->w]&0xff0000)>>16);
    if(tmpr>255) tmpr=255;
    tmpg = g+((pp[x+y*screen->w]&0x00ff00)>>8);
    if(tmpg>255) tmpg=255;
    tmpb = b+(pp[x+y*screen->w]&0x0000ff);
    if(tmpb>255) tmpb=255;
    pp[x+y*screen->w]=(tmpr<<16)|(tmpg<<8)|tmpb;
  }
}

void fillSintab() {
  int i;
  for(i=0;i<256;i++) {
    sintab[i] = sin((float)i/255*2*M_PI);
    costab[i] = cos((float)i/255*2*M_PI);
  }
}

void blitChar(unsigned char c,int sx,int sy, SDL_Surface *s,SDL_Surface *font) {
  int x,y;
  SDL_Rect srcrect,dstrect;
  tolower(c);
  if(c>=48 && c<58)
    c+=75;
  if(c>=97 && c<=132) {
    c -= 97;
    y = FONTH*c;
    x = y/FONTMAPH;
    y -= x*FONTMAPH;
    x *=FONTW;
    srcrect.x = x;
    srcrect.y = y;
    srcrect.w = FONTW;
    srcrect.h = FONTH;
    dstrect.x = sx;
    dstrect.y = sy;
    SDL_BlitSurface(font, &srcrect, s, &dstrect);
  }
}

void blitRipple(SDL_Surface *screen, ripstr *rs, Uint32 tid) {
  int i,j;
  float l,h,a;
  int lived=tid-rs->stid;

  for(j=rs->y-rs->maxl;j<rs->y+rs->maxl;j++) for(i=rs->x-rs->maxl;i<rs->x+rs->maxl;i++) {
  l = hypot(i-rs->x,j-rs->y);
    if(l > rs->v*(lived-rs->mtid)) {
      if(l<rs->v*lived && l<rs->maxl) {
	a = 128*(rs->maxl-l)/rs->maxl;
	h = a*sin(2*M_PI*rs->freq*(l-lived*rs->v)+M_PI)+a;
	//h = a*sintab[(int)(256*rs->freq*(l-lived*rs->v)+128)%255]+a;
	incpixel(screen,i,j,0,0,(unsigned char)h);
      }
    }
  }
}

void initRipple(ripstr *rs,int x,int y,float f,float v,float maxl,float mtid,Uint32 tid) {
  rs->x = x;
  rs->y = y;
  rs->freq = f;
  rs->maxl = maxl;
  rs->mtid = mtid;
  rs->tops = 0;
  rs->stid = tid; 
  rs->v = v;
}

void ljud(int n) {
  char c[100];
  sprintf(c,"mpg123 -q -n 40  droppe%i.mp3",n);
  if(fork()==0) {
    system(c);
    _exit(0);
  }
}




int main(void) {
  SDL_Surface *screen, *fontimg;
  SDL_Surface *image;
  SDL_Event event;
  ripstr *myRs[ANTAL_RIPPLE];
  int done=0;
  float move,vmove;
  float mpms=0.1;
  float vmpms = 0.002;
  Uint32 tid;
  int count=0;
  int i,x,y,hepp=0;
  Uint32 tidint = 1.2*1000;
  Uint32 lastrain,lastmove;
  float bokx[MAXBOK];
  float boky[MAXBOK];
  char bokc[MAXBOK];
  char greets[] = "berzanparty24";
  char blob[] = "greetings from upiom to crew and the rest at bp";

  fontimg = SDL_LoadBMP("./font.bmp");
  SDL_SetColorKey(fontimg,SDL_SRCCOLORKEY,0);

  if ( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0 ) {
    fprintf(stderr, "Unable to init SDL: %s\n", SDL_GetError());
    exit(1);
  }
  atexit(SDL_Quit);
  screen = SDL_SetVideoMode(640, 480, 32, SDL_SWSURFACE|SDL_FULLSCREEN);
  if ( screen == NULL ) { 
    fprintf(stderr, "Unable to set 640x480 video: %s\n", SDL_GetError());
    exit(1);
  }

  SDL_ShowCursor(SDL_DISABLE);

  fillSintab();

  for(i=0;i<MAXBOK;i++) {
    bokc[i] = ' ';
    bokx[i] = (int)(i*screen->w/MAXBOK);
    boky[i] = screen->h/2;
  }


  for(i=0;i<ANTAL_RIPPLE;i++) {myRs[i]=malloc(sizeof(ripstr));}
  
  srand((unsigned)time(NULL));
  image = IMG_Load("gnu.jpg");
  tid = SDL_GetTicks();
  lastrain = tid;
  lastmove = tid;
  while(!done) {
    SDL_FillRect(screen,0,0);
    tid = SDL_GetTicks();
    for(i=0;i<ANTAL_RIPPLE;i++) blitRipple(screen,myRs[i],tid);

    if(tid-lastrain > tidint) {
	count++;
	count = count%ANTAL_RIPPLE;
	initRipple(myRs[count],rand()%screen->w,rand()%screen->h,0.02,0.05,120,4900,tid);
	ljud((rand()%6)+1);
	lastrain = tid;
    }
    move = mpms*(float)(tid-lastmove);
    vmove = vmpms*(float)(tid-lastmove);
    lastmove = tid;
    
    for(i=0;i<MAXBOK;i++) {
      if(bokx[i]<screen->w/2) {
	bokx[i] -=move;
	boky[i] = (int)(40*sin((float)bokx[i]/64)) + screen->h/2;
	blitChar(bokc[i],(int)bokx[i],(int)boky[i],screen,fontimg);
	if(bokx[i]<-FONTW) {
	  bokx[i]=screen->w;
	  if(blob[hepp]!='\0') {
	    bokc[i]=blob[hepp];
	    hepp++;
	  } else {
	    bokc[i] = ' ';
	  }
	}
      } else {
	bokx[i]-=move;
	boky[i] = (int)(40*sin((float)bokx[i]/64)) + screen->h/2;
	blitChar(bokc[i],(int)bokx[i],(int)boky[i],screen,fontimg);
      }
    }

    for(i=0;greets[i]!='\0';i++) {
      //      x = 100*cos((float)i/9*2.5-vmpms*tid)+screen->w/2;
      // y = 100*sin((float)i/9*2.5-vmpms*tid)+screen->h/2;
      x=300+i*FONTW;
      y=440;
      blitChar(greets[i],x,y,screen,fontimg);
    }  

    SDL_UpdateRect(screen,0,0,0,0);    
    while(SDL_PollEvent(&event)) {
      switch (event.type) {
      case SDL_KEYDOWN:
	if ( event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; }
	break;
      case SDL_MOUSEBUTTONUP:
	count++;
	count = count%ANTAL_RIPPLE;
	initRipple(myRs[count],event.button.x,event.button.y,0.02,0.05,160,4900,tid);
      break;
      case SDL_QUIT:
	done=1;
      }
    }
  }

  printf("And if you actually whatched this for fully 16 seconds you must be very bored\n");

  for(i=0;i<ANTAL_RIPPLE;i++) free(myRs[i]);

  return 0;
}
