// Vector4.cpp: implementation of the CVector4 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Vector4.h"
#include "matrix4.h"
#include <math.h>

CVector4 temp_vector4;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVector4::CVector4()
{

}

CVector4::~CVector4()
{

}

CVector4 CVector4::operator *(CMatrix4 &m)
{
	return CVector4(m.value[0][0] * x + m.value[1][0] * y + m.value[2][0] * z + m.value[3][0] * w,
						    m.value[0][1] * x + m.value[1][1] * y + m.value[2][1] * z + m.value[3][1] * w,
						    m.value[0][2] * x + m.value[1][2] * y + m.value[2][2] * z + m.value[3][2] * w,
						    m.value[0][3] * x + m.value[1][3] * y + m.value[2][3] * z + m.value[3][3] * w);
}

float CVector4::operator *(CVector4 &v)
{
	return x * v.x + y * v.y + z * v.z + w * v.w;
}

CVector4::CVector4(float x, float y, float z, float w)
{
	CVector4::x = x;
	CVector4::y = y;
	CVector4::z = z;
	CVector4::w = w;
}

CVector4 CVector4::operator +(CVector4 v)
{
	return CVector4(x + v.x, y + v.y, z + v.z, w + v.w);
}

CVector4::CVector4(CVector &v)
{
	x = v.x; y = v.y; z = v.z; w = 0;
}

CVector4 CVector4::normalize()
{
	float n = (float)sqrt(x * x + y * y + z * z + w * w);
	return CVector4(x / n, y / n, z / n, w / n);
}

CVector4 CVector4::operator -(CVector4 &v)
{
	return CVector4(x - v.x, y - v.y, z - v.z, w - v.w);
}

