// Vector.cpp: implementation of the CVector class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Vector.h"
#include "Matrix.h"
#include <math.h>
#include "Vector4.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVector temp_vector;

CVector::CVector()
{
	x = 0; y = 0; z = 0;
}

CVector::~CVector()
{

}

void CVector::operator = (CVector &v) 
{
	x = v.x;
	y = v.y;
	z = v.z;
}

CVector CVector::operator + (CVector &v) 
{
	return CVector(x + v.x, y + v.y, z + v.z);
}

CVector CVector::operator - (CVector &v) 
{
	return CVector(x - v.x, y - v.y, z - v.z);
}

float CVector::operator * (CVector &v) 
{
	return x * v.x + y * v.y + z * v.z;
}

CVector CVector::operator * (float f)
{
	return CVector(x * f, y * f, z * f);
}

CVector CVector::operator * (CMatrix &m) 
{
	return CVector(m.value[0][0] * x + m.value[1][0] * y + m.value[2][0] * z,
						  m.value[0][1] * x + m.value[1][1] * y + m.value[2][1] * z,
						  m.value[0][2] * x + m.value[1][2] * y + m.value[2][2] * z);
}

CVector CVector::operator % (CVector &v) 
{
	return CVector(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x);
}


CVector::CVector(float x, float y, float z)
{
	CVector::x = x;
	CVector::y = y;
	CVector::z = z;
}

CVector & CVector::normalize()
{
	float mod = module();
	x /= mod;
	y /= mod;
	z /= mod;
	return *this;
}

float CVector::module()
{
	return (float)sqrt(x * x + y * y + z * z);
}

void CVector::operator += (CVector &v)
{
	x += v.x;
	y += v.y;
	z += v.z;
}

void CVector::operator -= (CVector &v)
{
	x -= v.x;
	y -= v.y;
	z -= v.z;
}

CVector & CVector::rotate(CVector &p, CVector &vd, float a)
{
	// Construimos la base local ortonormal (u, v, w)
	CVector w = CVector(vd).normalize();
	CVector A = p + (w * ((*this - p) * w));
	CVector v = *this - A;
	CVector u = v % w;

	// El vector en la nueva base es (0, |v|, 0). Lo rotamos con la matriz de rotacin
	CVector nv = CVector(0, v.module(), 0) * CMatrix(CVector((float)cos(a), (float)sin(a), 0), CVector((float)-sin(a), (float)cos(a), 0), CVector(0, 0, 1));

	// Volvemos a la base anterior con la matriz de cambio
	*this = nv * CMatrix(u.normalize(), v.normalize(), w) + A;

	return *this;
}

bool CVector::operator !=(CVector &v)
{
	return !(*this == v);
}

bool CVector::operator ==(CVector &v)
{
	return x == v.x && y == v.y && z == v.z;
}

CVector CVector::operator -()
{
	return CVector(-x, -y, -z);
}

CVector & CVector::operator =(CVector4 &v)
{
	x = v.x; y = v.y; z = v.z;
	return *this;
}

