// System.h: interface for the CSystem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYSTEM_H__C3FE1936_BBD1_4CF5_A3F7_F7A6BCEED4DE__INCLUDED_)
#define AFX_SYSTEM_H__C3FE1936_BBD1_4CF5_A3F7_F7A6BCEED4DE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gl/gl.h>
#include "viewport.h"

#define SOUND_SUPPORT			1

#define RENDER_LIGHTMAPPING		0x1
#define RENDER_LIGHTING			0x2
#define RENDER_FRONT_FACES		0x4
#define RENDER_BACK_FACES		0x8
#define RENDER_ALL_FX			(RENDER_LIGHTMAPPING | RENDER_LIGHTING | RENDER_FRONT_FACES)
#define RENDER_NORMALS			0x10
#define RENDER_BOUNDINGS		0x20
#define RENDER_BOUNDED			0x40
#define RENDER_PIVOT			0x80

class CSystem  
{
public:
	static CViewport *vp;
	static bool haveSound();
	static CViewport * getDefaultViewport();
	static void loadExtensions();
	static int getTextureUnits();
	static char * getExtensions();
	static void setLastError(int e);
	static int getLastError();
	CSystem();
	virtual ~CSystem();

private:
	static bool store_normals;
	static int tex_units;
	static char * gl_extensions;
	static int last_error;
	static bool sound_started;
};

#endif // !defined(AFX_SYSTEM_H__C3FE1936_BBD1_4CF5_A3F7_F7A6BCEED4DE__INCLUDED_)
