#include "SDL.h"
#include "SDL_image.h"
#include <stdlib.h>

class color
{
	public:
		color():r(0.0f),g(0.0f),b(0.0f){}
		color(float rr,float gg,float bb):r(rr),g(gg),b(bb){}
		color(const color &right):r(right.r),g(right.g),b(right.b){}

		unsigned char rc(void)const{return (unsigned char)(r*256.0f);}
		unsigned char gc(void)const{return (unsigned char)(g*256.0f);}
		unsigned char bc(void)const{return (unsigned char)(b*256.0f);}

		void rc(unsigned char c){r=((float)c)/256.0f;}
		void gc(unsigned char c){g=((float)c)/256.0f;}
		void bc(unsigned char c){b=((float)c)/256.0f;}
		
		float r;
		float g;
		float b;
};

void pset(int x,int y,const color &col,SDL_Surface *screen)
{
   Uint32 c= ((unsigned int)col.bc()) | (((unsigned int)col.gc())<<8) | (((unsigned int)col.rc())<<16);
   *((Uint32 *)screen->pixels + y*screen->pitch/4 + x)=c;
}

void pset(int x,int y,float r,float g,float b,SDL_Surface *screen)
{
   Uint32 c= (unsigned int)(b*255.0f) | (((unsigned int)(g*256.0f))<<8) | (((unsigned int)(r*256.0f))<<16);
   *((Uint32 *)screen->pixels + y*screen->pitch/4 + x)=c;
}

void pset(int x,int y,char r,char g,char b,SDL_Surface *screen)
{
   Uint32 c= ((unsigned int)b) | (((unsigned int)g)<<8) | (((unsigned int)r)<<16);
   *((Uint32 *)screen->pixels + y*screen->pitch/4 + x)=c;
}

void pset(int x,int y,int r,int g,int b,SDL_Surface *screen)
{
   Uint32 c= ((unsigned int)b) | (((unsigned int)g)<<8) | (((unsigned int)r)<<16);
   *((Uint32 *)screen->pixels + y*screen->pitch/4 + x)=c;
}

struct image
{
	SDL_Surface *i;
	int x,y;
	int w,h;
	bool blit;
};

image *image_create(char *file)
{
	image *dummy=(image *)malloc(sizeof(image));
	dummy->i=IMG_Load(file);
	if(dummy->i == NULL)
	{
		printf("Malamente! No carga\n");
	}
	dummy->blit=false;
	dummy->x=dummy->y=0;
	return dummy;
}

void image_blit(int x,int y,image *i,SDL_Surface *screen)
{
	SDL_Rect dest;
	if(x==-1 && y==-1)
	{
		x=i->x;
		y=i->y;
	}
	dest.x=x;
	dest.y=y;
	dest.w=i->i->w;
	dest.h=i->i->h;
	i->x=x;
	i->y=y;
	i->w=i->i->w;
	i->h=i->i->h;
	SDL_BlitSurface(i->i,NULL,screen,&dest);
}

void image_destroy(image *i)
{
	SDL_FreeSurface(i->i);
	free(i);
}

#include<math.h>
#include<vector>

struct rep
{
	SDL_Surface *screen;
	image *tipo;
	std::vector<image *> ropa;
};

void repaint(rep *r)
{
	int x,y;
	for(x=0;x<1024;x++)
		for(y=0;y<512;y++)
			pset(x,y,155+x/25+y*y/5000,155+x/25+y*y/5000,244,r->screen);
	image_blit(100,100,r->tipo,r->screen);   
	std::vector<image *>::iterator i;
	for(i=r->ropa.begin();i!=r->ropa.end();++i)
	{
		image_blit(-1,-1,(*i),r->screen);
	}
	SDL_UpdateRect(r->screen,0,0,0,0);
}


int main(int argc, char *argv[])
{
	rep r;
   r.screen=SDL_SetVideoMode(1024, 512, 32, SDL_SWSURFACE);
	r.tipo=image_create("model.png");

	r.ropa.push_back(image_create("pant.png"));
	r.ropa.push_back(image_create("sabates.png"));
	r.ropa.push_back(image_create("camiseta.png"));
	r.ropa.push_back(image_create("bufanda_gorro.png"));
	
	repaint(&r);

   SDL_Event event;
   int quit=0;
	bool click=false;
   while(!quit)
   {
      SDL_PollEvent(&event);
      switch (event.type) 
      {
			case SDL_MOUSEBUTTONDOWN:
				click=true;
			break;				
			case SDL_MOUSEBUTTONUP:
				click=false;
				break;
			case SDL_MOUSEMOTION:
				if(click)
				{
					std::vector<image *>::iterator i;
					for(i=r.ropa.begin();i!=r.ropa.end();++i)
					{
						if(event.motion.x > (*i)->x       && event.motion.y >  (*i)->y &&
							event.motion.x < ((*i)->x+(*i)->w) && event.motion.y < ((*i)->y+(*i)->h)) 
						{
							(*i)->x+=event.motion.xrel;
							(*i)->y+=event.motion.yrel;
						}
					}
					repaint(&r);
				}
			case SDL_KEYDOWN:
				break;
			case SDL_QUIT:
				quit=1;
				break;
      }
		
   }
	return 0;
}

