//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cTextureManager.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cTextureManager_hpp
#define cTextureManager_hpp
//==============================================================================
// Includes
#include <map>
#include <string>
#include <SDL.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Singleton texture manager
//------------------------------------------------------------------------------
class cTextureManager
{
	// Constructor & Destructor
	private:
		//! Constructor
		cTextureManager (void);
	public:
		//! Destructor
		~cTextureManager (void);
	
	// Public methods
	public:
		//! Return singleton
		static cTextureManager &GetInstance (void);
	
		//! Load texture from a file
		Uint32 LoadTexture (string filename);
		//! Get texture size
		void GetTextureSize (string filename, int &w, int &h);
	
		//! Free texture
		void FreeTexture (string filename);
		//! Free all textures
		void FreeAllTextures (void);
	
		void SetDataDir (const string &dir) { mDataDir = dir; };
		const string &GetDataDir (void) const { return mDataDir; };
	
	// Private methods
	private:
		//! Make texture from a SDL_Surface
		Uint32 MakeTexture (SDL_Surface *pTexture);
	
	// Member variables
	private:
		struct tTextureInfo
		{
			Uint32 ID;
			Uint16 width;
			Uint16 height;
		};
		map<string, tTextureInfo> mTextures;	//!< List of textures
		string mDataDir;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cTextureManager_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
