//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cMixer.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cMixer_hpp
#define cMixer_hpp
//==============================================================================
// Includes
#include <map>
#include <vector>
#include <string>
#include <SDL_mixer.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! Singleton sound mixer
class cMixer
{
	// Constructor & Destructor
	private:
		//! Constructor
		cMixer (void);
	public:
		//! Destructor
		~cMixer (void);
	
	// Public methods
	public:
		//! Return singleton
		static cMixer &GetInstance (void)
		{
			static cMixer singleton;
			return singleton;
		};
		
		//! Load sound
		Uint32 LoadSound (string filename);
		//! Free all sounds
		void FreeAllSounds (void);
		//! Free music
		void FreeMusic (void);
		
		//! Play sound
		int PlaySound (Uint32 sound, int loop = 0);
		//! Stop sound
		void StopSound (int channel,int delay=0 );
		//! Stop all sounds
		void StopAllSounds (void);
		//! Play music
		void PlayMusic (string filename);
		void FadeMusic (void);
		
		void SetMusicVolume (int volume);
		int GetMusicVolume (void);
		
		void SetSoundsVolume (int volume);
		int GetSoundsVolume (void);
		
		void SetDataDir (const string &dir) { mDataDir = dir; };
		const string &GetDataDir (void) const { return mDataDir; };
		
		void EnableSounds (bool value = true) { mSoundsEnabled = value; };
		void EnableMusic (bool value = true) { mMusicEnabled = value; };
	// Member variables
	private:
		bool mInitialized;
		bool mSoundsEnabled;
		bool mMusicEnabled;
		string mDataDir;
		map<string, Uint32> mSoundIDs;
		vector<Mix_Chunk*> mSounds;
		Mix_Music *mpMusic;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cMixer_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
