//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cRocketLauncher.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cRocketLauncher.hpp"
#include "cWorld.hpp"
#include "cRocket.hpp"
#include "Debug.hpp"
#include "cMixer.hpp"
#include "cAnimationManager.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cRocketLauncher::cRocketLauncher (void):
cWeapon (1, 0, 2000),
mSound (cMixer::GetInstance ().LoadSound ("rocket.wav")),
mReloadSound (cMixer::GetInstance ().LoadSound ("bazookareload.wav"))
{
	SetAmmo (1, 5);

};

//! Destructor
cRocketLauncher::~cRocketLauncher (void)
{
	// Empty
};

void 
cRocketLauncher::Fire (const cVector2f &position, float angle)
{
	SpawnSuuliekki ();
	
	mChannel = cMixer::GetInstance ().PlaySound (mSound);
	// Spawn a rocket
	cRocket *pRocket = new cRocket;
	pRocket->mAnimation.SetAnimation (cAnimationManager::GetInstance ().LoadAnimation ("rocket"));
	pRocket->mAnimation.SetNumberOfFrames (1);
	pRocket->mAnimation.SetFrameDelay (100000);
	pRocket->SetPosition (position);
	pRocket->SetRotation (angle);
	pRocket->SetChannel (mChannel);
	pRocket->SetOwner (GetOwner ());
	pRocket->Rotate (-2.0f + 4.0f * rand () / (RAND_MAX + 1.0f));
	pRocket->SetVelocity (pRocket->GetDirection () * 1.5f);
	cWorld::GetInstance ().SpawnObject (pRocket);
	
	pRocket->CreateSmokeSystem ();
}
void cRocketLauncher::BeginReload (void) {

	cMixer::GetInstance ().PlaySound (mReloadSound);

}

//==============================================================================
// EOF
//==============================================================================
