#include <iostream>
#include "cBullet.hpp"
#include "cPointer.hpp"
#include "Debug.hpp"

using namespace ShootingStar;

int main (int argc, char **argv)
{
	// Setup dbg
	dbg::enable (dbg::all, true);
	dbg::attach_ostream (dbg::info, cout);
	dbg::attach_ostream (dbg::warning, cout);
	dbg::enable_level_prefix (true);
	dbg::set_assertion_behaviour (dbg::all, dbg::assertions_throw);

	cPointer<cBullet> test;

	{
		cPointer<cBullet> mTest (new cBullet);
		if ( mTest.IsValid () )
			cout << "Pointer is valid" << endl;
		else
			cout << "Pointer is invalid" << endl;
		test = mTest;
	}
	cout << "ID " << test->GetID () << endl;
	if ( test.IsValid () )
		cout << "Pointer is valid" << endl;
	else
		cout << "Pointer is invalid" << endl;
	
}
