;       Spiral drawer
;      for the 4EvEr03
;    128 byte intro compo
;
; code:  bubis/Resource
; email: bubis@resource.cx

.org $1001-2
.word $1001

	.word bas_end
	.word 2003
	.byte $de,"1,1:"	;graphic1,1:
	.byte $9e,"4114"	;sys4114
	.byte 0
bas_end:
	.byte 0,0

xc = $02ad
yc = $02af
plot = $c1a5


points = 32	;power of 2
groups = 4	;power of 2

startcoors = $88a5

coords = $0800
offsnext = 4
offslo = 1

.zeropage

lo = $d0
hi = $d1
count = $d2

.code


sys4114:
	inc $84
	lda #$71
	sta $ff19

	ldx #<(points*offsnext)
:	lda startcoors-1,x
	sta coords-1,x
	dex
	bne :-
	

cyc:

	ldy #(4*groups)
:	lda coords-1,y
	sta coords+points*offsnext-1,y
	dey
	bne :-

	lda count
	inc count

	and #(points-1)
	asl
	asl
	tax
	jsr step
	inx
	inx
	jsr step

	lda coords-2+1,x
	sta xc
	lda coords-2+2+1,x
	sta yc
	jsr plot

	jmp cyc

	
step:
;	sec
	lda coords+offsnext*groups,x
	sbc coords,x	
	sta lo
	lda coords+offsnext*groups+1,x
	sbc coords+1,x
	sta hi
	tya
	sbc #0
	ldy #6		;div by 2^6
div:	ror
	ror hi
	ror lo
	dey
	bne div
;	clc
	lda coords,x
	adc lo
	sta coords,x
	lda coords+1,x
	adc hi
	sta coords+1,x
	rts
