/*
 * Sesse's demolib
 */ 

#include <stdio.h>
#include <string.h>

#include "demolib_prefs.h"
#include "image.h"
#include "jpeg_image.h"
#include "png_image.h"
#include "packer/file.h"
#include "../exception.h"

#if !defined(__GNUC__) && !defined(__ICC__)
#define strcasecmp stricmp
#endif

Image *load_image(const char * const filename)
{
	File *file = load_file(filename);

	/* find out what kind of image this is by looking at the extension */
#if DEMOLIB_IMAGE_JPEG
	if (strcasecmp(filename + strlen(filename) - 4, ".jpg") == 0 ||
	    strcasecmp(filename + strlen(filename) - 5, ".jpeg") == 0) {
		Image *img = new JPEGImage(file);
		delete file;
		return img;
	}
#endif /* DEMOLIB_IMAGE_JPEG */
	
#if DEMOLIB_IMAGE_PNG
	if (strcasecmp(filename + strlen(filename) - 4, ".png") == 0) {
		Image *img = new PNGImage(file);
		delete file;
		return img;
	}
#endif /* DEMOLIB_IMAGE_PNG */

	throw new FatalException("Couldn't figure out type of image");
}
