{$mode delphi}
unit efx1;

interface

uses windows,gl,efx3;

function efx1_init_new (note, volume: word): boolean;
procedure efx1_draw;

implementation

const 
	max = 5;
	tt = 350;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		x,y: glfloat;
		r,g,b,a: glfloat;
		typ: integer;
	end;
	
function efx1_init_new (note, volume: word): boolean;
var i,j: integer;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		x:=random;
		y:=random;
		r:=random; g:=random; b:=random; a:=(volume/64)+0.1;
		if a>1.0 then a:=1.0;
		typ:=random(2);
		{$ifdef debug}
		writeln(note);
		{$endif}
		if note=57 then begin
			efx3_init_new(note,volume);
			playing:=false;
		end;
	end;
end;
	
procedure efx1_draw;
var t: longint;
	i: integer;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		glColor4f(r,g,b,a-(t/tt)*a);
		glPushMatrix();
		glTranslatef(x,y,0);
		glRotatef(r*360,0,0,1);
		case typ of
			0: glRectf(-0.3,-0.3,0.3,0.3);
			1: begin
				glBegin(GL_QUADS);
				glVertex2f(-0.3,0.3); glVertex2f(0.3,0.3); glVertex2f(0.2,0.2); glVertex2f(-0.2,0.2);
				glVertex2f(0.3,0.3); glVertex2f(0.3,-0.3); glVertex2f(0.2,-0.2); glVertex2f(0.2,0.2);
				glVertex2f(-0.2,-0.2); glVertex2f(0.2,-0.2); glVertex2f(0.3,-0.3); glVertex2f(-0.3,-0.3);
				glVertex2f(-0.3,0.3); glVertex2f(-0.2,0.2); glVertex2f(-0.2,-0.2); glVertex2f(-0.3,-0.3);
				glEnd();
			end;
			2:begin
				glLoadIdentity();
				glColor4f(0.8,0.8,0.3,1.0);
				glRectf(0,0,1,1);
			end;
		end;
		glPopMatrix();
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.