#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <GL/gl.h>
#include "SDL.h"
#include <vorbis/vorbisfile.h>
#include <obstack.h>
#include <jpeglib.h>
#include "anarchy.h"
#include "scene.h"
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>


void *mymalloc(Space *m, int bytes) { return malloc(bytes); }
void myrealloc(Space *m, void **p, int newsize) { if (*p) *p=realloc(*p, newsize); else *p=malloc(newsize); }
void myfree(Space *m, void **p) { free(*p); *p=0; }
Space stdmem={ {0}, mymalloc, myrealloc, myfree, 0 };


#ifndef M_PI
#define M_PI 3.14159265
#endif

#define obstack_chunk_alloc malloc
#define obstack_chunk_free free


/*void jm_init_source(j_decompress_ptr cinfo) { cinfo->src->bytes_in_buffer=1638400; }
unsigned char jm_fill_input_buffer(j_decompress_ptr cinfo) { cinfo->src->bytes_in_buffer=1638400; return 0; }
void jm_skip_input_data(j_decompress_ptr cinfo, long num_bytes) { cinfo->src->next_input_byte+=num_bytes; cinfo->src->bytes_in_buffer=1638400; }
unsigned char jm_resync_to_restart(j_decompress_ptr cinfo, int desired) { exit(1); return 0; }
void jm_term_source(j_decompress_ptr cinfo) { }

extern int jpg_fukk[];
unsigned char *luejipeg(int *dataptr) {
  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;
  JSAMPARRAY buffer;
  int row_stride;
  int x;
  char *resu, *p;

  cinfo.err = jpeg_std_error(&jerr);
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, stdin);
  cinfo.src->next_input_byte=(void*)dataptr;
  cinfo.src->bytes_in_buffer=0;
  cinfo.src->init_source=jm_init_source;
  cinfo.src->fill_input_buffer=jm_fill_input_buffer;
  cinfo.src->skip_input_data=jm_skip_input_data;
  cinfo.src->resync_to_restart=jm_resync_to_restart;
  cinfo.src->term_source=jm_term_source;
  jpeg_read_header(&cinfo, 1);
  jpeg_start_decompress(&cinfo);
  row_stride = cinfo.output_width*cinfo.output_components;
  buffer = (*cinfo.mem->alloc_sarray)
    ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  p=resu=malloc(cinfo.output_height*cinfo.output_width*3);
  while (cinfo.output_scanline < cinfo.output_height) {
    jpeg_read_scanlines(&cinfo, buffer, 1);
    for (x=0; x<(int)cinfo.output_width*3; x++) *p++=buffer[0][x];
    //put_scanline_someplace(buffer[0], row_stride);
  }
  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);
  //fclose(infile);
  return resu;
}*/
unsigned char *luejipeg2(FILE *fp, int *koko) {
  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;
  JSAMPARRAY buffer;
  int row_stride;
  int x;
  char *resu, *p;
  cinfo.err = jpeg_std_error(&jerr);
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, fp);
  jpeg_read_header(&cinfo, 1);
  jpeg_start_decompress(&cinfo);
  row_stride = cinfo.output_width*cinfo.output_components;
  buffer = (*cinfo.mem->alloc_sarray)
    ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  p=resu=malloc(cinfo.output_height*cinfo.output_width*cinfo.output_components);
  while (cinfo.output_scanline < cinfo.output_height) {
    jpeg_read_scanlines(&cinfo, buffer, 1);
    for (x=0; x<(int)cinfo.output_width*cinfo.output_components; x++) *p++=buffer[0][x];
  }
  if (koko) {
    koko[0]=cinfo.output_width;
    koko[1]=cinfo.output_height;
    koko[2]=cinfo.output_components;
  }
  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);
  return resu;
}


vorbis_info *ogginf;





/* new window size or exposure */
static void reshape(int width, int height) {
  float h=(float) height / (float) width;
  glViewport(0, 0, (int) width, (int) height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-.01, .01, -h*.01, h*.01, .005, 600.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
 // glTranslatef(0.0, 0.0, -2.5);
}


void tyhtex(int no, int xsize, int ysize) {
  static char buf[262144];
  int kok[3], miplev, x, y, p;
  glBindTexture(GL_TEXTURE_2D, no);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB4, xsize, ysize, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
}
void lataatex(int no, char *nami, int flags) {
  static unsigned char *buf;
  int kok[3], miplev, x, y, p;
  glBindTexture(GL_TEXTURE_2D, no);
  {
    FILE *fp=fopen(nami, "r");
    buf=luejipeg2(fp, &kok); fclose(fp);
  } 
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  if (flags&1) {
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
  } else {
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  }
  for (miplev=0; miplev<16; miplev++) {
    glTexImage2D(GL_TEXTURE_2D, miplev, kok[2]==3?GL_RGB4:GL_LUMINANCE4, kok[0], kok[1], 0, kok[2]==3?GL_RGB:GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
    kok[0]>>=1; kok[1]>>=1;
    if (!(flags&1) || kok[0]==0 || kok[1]==0) break;
    for (p=0; p<kok[2]; p++) for (y=0; y<kok[1]; y++) for (x=0; x<kok[0]; x++) {
      buf[(y*kok[0]+x)*kok[2]+p]=
        buf[(y*2*kok[0]*2+x*2)*kok[2]+p]+
        buf[(y*2*kok[0]*2+x*2+1)*kok[2]+p]+
        buf[((y*2+1)*kok[0]*2+x*2)*kok[2]+p]+
        buf[((y*2+1)*kok[0]*2+x*2+1)*kok[2]+p]+2>>2;
    }
  }
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  free(buf);
}
//147, 12, 8

static void init(struct obstack *obs, int argc, char *argv[]) {

  int i;

//  tridesign_normalize(obju);
  lataatex(0, "pics/japanowosu03c.jpg", 0);//
  lataatex(1, "pics/cman2.jpg", 0);//
  lataatex(2, "pics/japanowosu04b.jpg", 0);//
  lataatex(3, "pics/tranke1.jpg", 0);//
  lataatex(4, "pics/tranke2.jpg", 0);//
//  lataatex(5, "pics/cman2.jpg", 0);//
  lataatex(6, "pics/kikkeli1_ver2.jpg", 0);//
  lataatex(7, "pics/kikkeli5_ver3lo.jpg", 0);//
  lataatex(8, "pics/kikkeli5_ver3lo.jpg", 0);//
  lataatex(9, "pics/valot2.jpg", 0);//
  lataatex(10, "pics/216.jpg", 0);//
  lataatex(11, "pics/unclex.jpg", 0);//
  lataatex(12, "pics/bitchard.jpg", 0);//
  lataatex(13, "pics/manticore.jpg", 0);//
  lataatex(14, "pics/synteesi.jpg", 0);//
  lataatex(15, "pics/nosfe.jpg", 0);//
  lataatex(16, "pics/surge_1a.jpg", 0);//
  lataatex(17, "pics/surge_1b.jpg", 0);//
  lataatex(18, "pics/surge_1c.jpg", 0);//
  lataatex(19, "pics/valotpallot.jpg", 0);//
  lataatex(20, "pics/marboctt2.jpg", 1);//
  lataatex(21, "pics/mfx_1a.jpg", 0);//
  lataatex(22, "pics/mfx_1b.jpg", 0);//
  lataatex(23, "pics/mfx_1c.jpg", 0);//
  lataatex(24, "pics/trankearrows2.jpg", 0);//
  lataatex(25, "pics/churchfp.jpg", 1);//
  lataatex(26, "pics/roof.jpg", 1);//
  lataatex(27, "pics/sisti.jpg", 1);//
  lataatex(28, "pics/Travertn.jpg", 1);//
  lataatex(29, "pics/lasimaalaus3.jpg", 0);//
  tyhtex(30, 128, 128);
  tyhtex(31, 256, 256);
  tyhtex(32, 512, 256);
//  lataatex(11, "pics/kikkeli5_ver2.jpg");

  glEnable(GL_TEXTURE_2D);
  glEnable(GL_NORMALIZE);

  if (argc>1 && strcmp(argv[1], "-info")==0) {
     printf("GL_RENDERER  =%s\n", (char *) glGetString(GL_RENDERER));
     printf("GL_VERSION   =%s\n", (char *) glGetString(GL_VERSION));
     printf("GL_VENDOR    =%s\n", (char *) glGetString(GL_VENDOR));
     printf("GL_EXTENSIONS=%s\n", (char *) glGetString(GL_EXTENSIONS));
  }
}


void bpmcalc(float val) {
  static float a=0, b=0, aprev=0;
  static int stat=0, counter=0, cntsum=0, cntlkm=0;
  const int minimum=44100*60/160, maximum=44100*60/130;
  aprev=a;
  b+=(val*val-b)*.0002; 
  a+=(b-a)*.0001; 
  if (a>aprev && stat==0) {
    stat=1;
  }
  if (a<aprev && a>0.01 && stat==1) {
    if (counter<maximum && counter>minimum) {
      cntsum+=counter;
      cntlkm++;
      printf("%f  ", 44100*60./counter);
      printf("%f\n", 44100*60./(cntsum/cntlkm));
    }
    stat=0;
    if (counter>minimum) counter=0;
  }
  counter++;
}


void auproc(short *data, int cnt) {
  static float a[256]={0};
  const float c=1./tan(M_PI*170./44100.);
  const float a0=1./(1.+sqrt(2.)*c+c*c), a1=2*a0, a2=a0, b1=-2*(1.-c*c)*a0, b2=-(1.-sqrt(2.)*c+c*c)*a0;
/*  const float c=tan(M_PI*11500./44100.);
  const float a0=1./(1.+sqrt(2.)*c+c*c), a1=-2*a0, a2=a0, b1=-2*(c*c-1.)*a0, b2=-(1.-sqrt(2.)*c+c*c)*a0;*/
  static int p=0;
  int i;
  for (i=0; i<cnt; i++) {
    a[p+2&255]=data[i]*(1/32768.);
    a[p&255]=a[p-2&255]*b2+a[p-1&255]*b1+a[p&255]*a0+a[p+1&255]*a1+a[p+2&255]*a2;
    bpmcalc(a[p&255]);
    data[i]=(a[p&255]<-1?-1:a[p&255]>1?1:a[p&255])*32768;
    p++;
  }
}

float ittrick=0;
int funkki=0;
void audioback(void *oggi, unsigned char *stream, int len) {
  int i, lkm, foo=0, left;
  unsigned char *sp;
  static int ovpos=0;
  if (funkki) { int a=len*funkki>>ogginf->channels; if (a<-ovpos) a=-ovpos; ovpos+=a; ittrick+=a*(1./44100.); ov_pcm_seek(oggi, ovpos); }
  for (left=len, sp=stream; len>0; sp+=lkm, left-=lkm) {
    lkm=ov_read(oggi, sp, left, 0, 2, 1, &foo);
    if (!lkm) break;
  }
  ovpos+=len>>ogginf->channels;
//  auproc(stream, len>>1);
}
void audioback2(void *oggi, unsigned char *stream, int len) {
  static short buf[262144];
  int i;
  audioback(oggi, buf, len*4);
  for (i=0; i<len>>1; i++) ((short*)stream)[i]=buf[i*4];
}



void demota(Space *, float);
int main(int argc, char **argv) {
  SDL_Surface *screen;
  int done;
  Uint8 *keys;
  static SDL_AudioSpec aanispex;
  FILE *fp;
  OggVorbis_File oggi;
  char *modname="ank.ogg";
  struct obstack obs;
  struct itimerval it;
  float timmy_0;
#define BPM 143.368
//#define BPM 140*1.05946
//#define BPM 152
  Register *r;
  Region *mip=spaceregion(&stdmem, 10, 10);

  obstack_init(&obs);
  SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO);
  screen=SDL_SetVideoMode(640, 480, 16, SDL_OPENGL|SDL_FULLSCREEN|SDL_RESIZABLE|SDL_HWSURFACE);
  if (!screen) {
    fprintf(stderr, "Couldn't set video mode: %s\n", SDL_GetError());
    SDL_Quit();
    exit(1);
  }
  SDL_WM_SetCaption("foo", "bar");
  prekalki(&stdmem);

  {
  GLint mev, mei;
  glGetIntegerv(GL_MAX_ELEMENTS_VERTICES, &mev); glGetIntegerv(GL_MAX_ELEMENTS_INDICES, &mei);
  printf("mev: %i, mei: %i\n", mev, mei);
  }

  fp=fopen(modname, "rb");
  if (!fp || ov_open(fp, &oggi, 0, 0)<0) {
    fprintf(stderr, "error in %s", modname);
    return 1;
  }
  ogginf=ov_info(&oggi, -1);
  aanispex.freq=ogginf->rate;
  aanispex.format=AUDIO_S16;
  aanispex.channels=ogginf->channels;
  aanispex.samples=4096;
  aanispex.callback=audioback;
  aanispex.userdata=&oggi;
  if (SDL_OpenAudio(&aanispex, 0)<0) {
    fprintf(stderr, "sdlerror %s\n", SDL_GetError());
    //return 1;
  }



  SDL_ShowCursor(0);
  init(&obs, argc, argv);
  reshape(screen->w, screen->h);
  done=0;
  timmy_0=SDL_GetTicks();
  {
    it.it_value.tv_sec=1000;
    it.it_value.tv_usec=0;
    it.it_interval.tv_sec=0;
    it.it_interval.tv_usec=0;
    setitimer(ITIMER_REAL, &it, 0);
  }
  SDL_PauseAudio(0);
  while (!done) {
    SDL_Event event;
    
    while (SDL_PollEvent(&event)) {
      switch (event.type) {
        case SDL_VIDEORESIZE:
          screen=SDL_SetVideoMode(event.resize.w, event.resize.h, 16, SDL_OPENGL|SDL_RESIZABLE);
          if (screen) reshape(screen->w, screen->h);
          break;
        case SDL_QUIT:
          done=1;
          break;
      }
    }
    keys=SDL_GetKeyState(NULL);
    if (keys[SDLK_ESCAPE]) done=1;
    funkki=keys[SDLK_KP6]?2:keys[SDLK_KP8]?9:keys[SDLK_KP2]?-11:keys[SDLK_KP4]?-4:keys[SDLK_KP5]?-1:0;
/*    if (keys[SDLK_UP]) view_rotxi += 1.5;
    if (keys[SDLK_DOWN]) view_rotxi -= 1.5;
    if (keys[SDLK_LEFT]) view_rotyi += 1.5;
    if (keys[SDLK_RIGHT]) view_rotyi -= 1.5;
    if (keys[SDLK_z]) view_rotzi+=SDL_GetModState()&KMOD_SHIFT?-1.5:1.5;*/

    getitimer(ITIMER_REAL, &it);

    glShadeModel(GL_SMOOTH);
    glCullFace(GL_BACK);
    glPolygonMode(GL_FRONT, keys[SDLK_RSHIFT]?GL_LINE:GL_FILL);
    glPolygonMode(GL_BACK, keys[SDLK_RSHIFT]?GL_LINE:GL_FILL);
    glEnable(GL_CULL_FACE);
    glDisable(GL_LIGHTING);
    glDisable(GL_LIGHT0);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_NORMALIZE);
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    {
      float t=(1000-(it.it_value.tv_sec+it.it_value.tv_usec*.000001)-(aanispex.samples/aanispex.freq+.1)+ittrick)*(BPM/16./60.);
      demota(&stdmem, t);  
  //    demota(&stdmem, (1000-(it.it_value.tv_sec+it.it_value.tv_usec*.000001)-((3*4096)/44100.0)+ittrick)*(BPM/16./60.));
      if (t>(45.0+((8*5+2 )/128.0))) done++;    
    }
    glPopAttrib();


//    demota(&stdmem, (SDL_GetTicks()-timmy_0)*(BPM/16/60000.));
//    draw();
    {
    static int frloob=0;
    if (frloob++&0) glFlush(); else glFinish();
    }
  }
  SDL_ShowCursor(1);
  SDL_PauseAudio(1);
  SDL_CloseAudio();
  ov_clear(&oggi);
  fclose(fp);
  SDL_FreeSurface(screen);
//  SDL_Quit();
  return 0;     
}

























