
void glpushad() {
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
}

void glpopad() {
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glPopAttrib();
}



void makesphere(Design *o, int a, int b, float xrad, float yrad) {
  int x, y;
  Region *vp, *vn, *vt, *fi;
  int vpd, vnd, vtd, fid;
  char *vpp, *vnp, *vtp, *fip;
  vp=ind_get(o->verts, "pos");
  vn=ind_get(o->verts, "normal");
  vt=ind_get(o->verts, "texture");
  fi=ind_get(o->faces, "index");
  vpp=rgn_map(vp, 0, (a+1)*(b+1), &vpd);
  vnp=rgn_map(vn, 0, (a+1)*(b+1), &vnd);
  vtp=rgn_map(vt, 0, (a+1)*(b+1), &vtd);
  fip=rgn_map(fi, 0, a*b*2, &fid);
  for (y=0; y<=a; y++) for (x=0; x<=b; x++) {
    float *v=(float*)(vpp+(y*(b+1)+x)*vpd);
    float *n=(float*)(vnp+(y*(b+1)+x)*vnd);
    float *t=(float*)(vtp+(y*(b+1)+x)*vtd);
    float xs=sin(x*M_PI*2/b), xc=cos(x*M_PI*2/b), 
          ys=sin(y*M_PI/a), yc=cos(y*M_PI/a);
    v[0]=xs*ys*xrad; v[1]=yc*yrad; v[2]=xc*ys*xrad; v[3]=1;
    n[0]=xs*ys; n[1]=yc; n[2]=xc*ys; n[3]=0;
    t[0]=x*(1./b); t[1]=y*(1./a);
  }
  for (y=0; y<a; y++) for (x=0; x<b; x++) {
    short *f=(short*)(fip+(y*b+x)*2*fid);
    f[0]=y*(b+1)+x;
    f[2]=y*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+(x+1);
    f=(short*)(fip+((y*b+x)*2+1)*fid);
    f[0]=y*(b+1)+x;
    f[2]=(y+1)*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+x;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vn, vnp);
  rgn_unmap(vt, vtp);
  rgn_unmap(fi, fip);
}

void makecyl(Design *o, int a, int b, float xrad, float yrad, float tpos) {
  int x, y;
  Region *vp, *vn, *vc, *vt, *fi;
  int vpd, vnd, vcd, vtd, fid;
  char *vpp, *vnp, *vcp, *vtp, *fip;
  vp=ind_get(o->verts, "pos");
  vn=ind_get(o->verts, "normal");
  vc=ind_get(o->verts, "colour");
  vt=ind_get(o->verts, "texture");
  fi=ind_get(o->faces, "index");
  vpp=rgn_map(vp, 0, (a+1)*(b+1), &vpd);
  vnp=rgn_map(vn, 0, (a+1)*(b+1), &vnd);
  vcp=rgn_map(vc, 0, (a+1)*(b+1), &vcd);
  vtp=rgn_map(vt, 0, (a+1)*(b+1), &vtd);
  fip=rgn_map(fi, 0, a*b*2, &fid);
  for (y=0; y<=a; y++) for (x=0; x<=b; x++) {
    float *v=(float*)(vpp+(y*(b+1)+x)*vpd);
    float *n=(float*)(vnp+(y*(b+1)+x)*vnd);
    float *c=(float*)(vcp+(y*(b+1)+x)*vcd);
    float *t=(float*)(vtp+(y*(b+1)+x)*vtd);
    float xs=sin(x*M_PI*2/b), xc=cos(x*M_PI*2/b);
    v[0]=xs*xrad; v[1]=yrad-y*(2*yrad/a); v[2]=xc*xrad; v[3]=1;
    n[0]=yrad<0?-xs:xs; n[1]=0; n[2]=yrad<0?-xc:xc; n[3]=0;
    c[0]=c[1]=c[2]=c[3]=1;
    t[0]=x*(1./b); t[1]=y*(1./a)+tpos;
  }
  for (y=0; y<a; y++) for (x=0; x<b; x++) {
    short *f=(short*)(fip+(y*b+x)*2*fid);
    f[0]=y*(b+1)+x;
    f[2]=y*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+(x+1);
    f=(short*)(fip+((y*b+x)*2+1)*fid);
    f[0]=y*(b+1)+x;
    f[2]=(y+1)*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+x;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vc, vcp);
  rgn_unmap(vn, vnp);
  rgn_unmap(vt, vtp);
  rgn_unmap(fi, fip);
}

void distfade(Design *o, float xc, float yc, float zc, float d) {
  Region *vp=ind_get(o->verts, "pos");
  Region *vc=ind_get(o->verts, "colour");
  int vpd, vcd, i, cnt=rgn_getsize(vp);
  char *vpp, *vcp;
  vpp=rgn_map(vp, 0, cnt, &vpd);
  vcp=rgn_map(vc, 0, cnt, &vcd);
  for (i=0; i<cnt; i++) {
    float *v=(float*)(vpp+i*vpd);
    float *c=(float*)(vcp+i*vcd);
    float k=exp(-sqrt((v[0]-xc)*(v[0]-xc)+(v[1]-yc)*(v[1]-yc)+(v[2]-zc)*(v[2]-zc))/d);
    c[0]*=k; c[1]*=k; c[2]*=k;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vc, vcp);
}


static void minmax(Design *o, float *mm) {
  Region *vp=ind_get(o->verts, "pos");
  mm[0]= 1000000; mm[1]= 1000000; mm[2]= 1000000; mm[3]= 1000000;
  mm[4]=-1000000; mm[5]=-1000000; mm[6]=-1000000; mm[7]=-1000000;
  rgn_bfor(vp, float, v)
    if (v[0]<mm[0]) mm[0]=v[0]; if (v[0]>mm[4]) mm[4]=v[0];
    if (v[1]<mm[1]) mm[1]=v[1]; if (v[1]>mm[5]) mm[5]=v[1];
    if (v[2]<mm[2]) mm[2]=v[2]; if (v[2]>mm[6]) mm[6]=v[2];
    if (v[3]<mm[3]) mm[3]=v[3]; if (v[3]>mm[7]) mm[7]=v[3];
  rgn_efor(vp, v)
}




void maketext(Group *d, Group *fon, char *str, float spacing) {
  static float matr[16]={1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
  char *s;
  float po[8];
  float totw=0;
  char chr[2]={0,0};

  for (s=str; *s; s++) {
    Member *m;
    chr[0]=*s;
    m=member_find(fon, chr);
    if (m) minmax(m, po), totw+=po[4]-po[0];
    totw+=spacing;
  }
  matr[12]=totw*.5;
  for (s=str; *s; s++) {
    Member *m;
    chr[0]=*s;
    m=member_find(fon, chr);
    if (m) {
      minmax(m, po);
      matr[12]-=po[4];
      group_add(d, m, matr);
      matr[12]+=po[0];
    }
    matr[12]-=spacing;
  }
}




#define v4_comb(d, s1, k1, s2, k2) ({float *_d00=(d), *_s00=(s1), *_s01=(s2), _k00=(k1), _k01=(k2); _d00[0]=_s00[0]*_k00+_s01[0]*_k01, _d00[1]=_s00[1]*_k00+_s01[1]*_k01, _d00[2]=_s00[2]*_k00+_s01[2]*_k01, _d00[3]=_s00[3]*_k00+_s01[3]*_k01;})
#define v4_add(d, s1, s2) (v4_comb((d), (s1), 1, (s2), 1))
#define v4_sub(d, s1, s2) (v4_comb((d), (s1), 1, (s2), -1))
#define v4_mul(d, s, k) ({float *_s02=(s); v4_comb((d), _s02, k, _s02, 0);})
#define v4_clr(d) ({float *_d01=(d); v4_mul(_d01, _d01, 0); })
#define v4_dot(s1, s2) ({float *_s03=(s1), *_s04=(s2); _s03[0]*_s04[0]+_s03[1]*_s04[1]+_s03[2]*_s04[2]+_s03[3]*_s04[3];})
#define v4_dot3(s1, s2) ({float *_s05=(s1), *_s06=(s2); _s05[0]*_s06[0]+_s05[1]*_s06[1]+_s05[2]*_s06[2];})
#define v4_norm3(d, s) ({float *_s07=(s); v4_mul((d), _s07, 1./sqrt(v4_dot3(_s07, _s07)));})
#define v4_cross3(d, s1, s2) ({float *_d02=(d), *_s08=(s1), *_s09=(s2); _d02[0]=_s08[1]*_s09[2]-_s08[2]*_s09[1], _d02[1]=_s08[2]*_s09[0]-_s08[0]*_s09[2], _d02[2]=_s08[0]*_s09[1]-_s08[1]*_s09[0], _d02[3]=0;})
#define swap(a, b) ({typeof(a) t; t=(a), (a)=(b), (b)=t;})
#define sqr(x) ({typeof(x) _4536=(x); _4536*_4536; })




void makevip2(Design *o, int a, int b, float t0, float len, float *col, void (*fun)(float *pos, float t, float t2, float *par), float *par) {  int x, y;
  Region *vp, *vn, *vc, *vt, *fi;
  int vpd, vnd, vcd, vtd, fid;
  char *vpp, *vnp, *vcp, *vtp, *fip;
  vp=ind_get(o->verts, "pos");
  vn=ind_get(o->verts, "normal");
  vc=ind_get(o->verts, "colour");
  vt=ind_get(o->verts, "texture");
  fi=ind_get(o->faces, "index");
  vpp=rgn_map(vp, 0, (a+1)*(b+1), &vpd);
  vnp=rgn_map(vn, 0, (a+1)*(b+1), &vnd);
  vcp=rgn_map(vc, 0, (a+1)*(b+1), &vcd);
  vtp=rgn_map(vt, 0, (a+1)*(b+1), &vtd);
  fip=rgn_map(fi, 0, a*b*2, &fid);
  for (y=0; y<=a; y++) {
    float pp[32], yve[]={0, 1, 0, 0};
    float ivec[4], jvec[4], kvec[4];
    float t=t0+(1-(1-y*1./a)*(1-y*1./a))*len;
    pp[4]=pp[5]=pp[6]=y*(1./a); pp[7]=y*(1./a);
    fun(pp, t, y*1./a, par); fun(pp+8, t+0.001, y*1./a, par);
    v4_sub(kvec, pp+8, pp); v4_norm3(kvec, kvec);
    v4_cross3(ivec, kvec, yve); v4_norm3(ivec, ivec);
    v4_cross3(jvec, ivec, kvec); v4_norm3(jvec, jvec);
    for (x=0; x<=b; x++) {
      float *v=(float*)(vpp+(y*(b+1)+x)*vpd);
      float *n=(float*)(vnp+(y*(b+1)+x)*vnd);
      float *c=(float*)(vcp+(y*(b+1)+x)*vcd);
      float *t=(float*)(vtp+(y*(b+1)+x)*vtd);
      float xs=sin(x*M_PI*2/b), xc=cos(x*M_PI*2/b);
      v4_comb(n, ivec, xs, jvec, xc);
//      n[0]=ivec[0]*xs+jvec[0]*xc; n[1]=ivec[1]*xs+jvec[1]*xc; n[2]=pp[10]*xs+pp[14]*xc;
      v4_comb(v, pp, 1, n, pp[3]); v[3]=1;
//      v[0]=pp[0]+n[0]*pp[3]; v[1]=pp[1]+n[1]*pp[3]; v[2]=pp[2]+n[2]*pp[3];
//    c[0]=c[1]=c[2]=y*(1./a); c[3]=y*(1./a);
      c[0]=pp[4]; c[1]=pp[5]; c[2]=pp[6]; c[3]=pp[7];
      t[0]=x*(1./b); t[1]=y*(1./a);
    }
  }
  for (y=0; y<a; y++) for (x=0; x<b; x++) {
    short *f=(short*)(fip+(y*b+x)*2*fid);
    f[0]=y*(b+1)+x;
    f[2]=y*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+(x+1);
    f=(short*)(fip+((y*b+x)*2+1)*fid);
    f[0]=y*(b+1)+x;
    f[2]=(y+1)*(b+1)+(x+1);
    f[1]=(y+1)*(b+1)+x;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vc, vcp);
  rgn_unmap(vn, vnp);
  rgn_unmap(vt, vtp);
  rgn_unmap(fi, fip);
}






static inline float inoise(int x, int y, int z) {
  int a=x*453415497+y*692345763^z*473546769;
  int b=y*213452313+z*685246969^x*743457661;
  int c=z*915876951+x*456766761^y*421345463;
  int d=a*584278733+b*543588311^c*943566311;
  return (d>>10&65535)*(1/65536.);
}

static inline float noise(float x, float y, float z) {
  int xi=lrint(x-.5), yi=lrint(y-.5), zi=lrint(z-.5);
  float n000=inoise(xi, yi, zi);
  float n001=inoise(xi, yi, zi+1);
  float n010=inoise(xi, yi+1, zi);
  float n011=inoise(xi, yi+1, zi+1);
  float n100=inoise(xi+1, yi, zi);
  float n101=inoise(xi+1, yi, zi+1);
  float n110=inoise(xi+1, yi+1, zi);
  float n111=inoise(xi+1, yi+1, zi+1);
  float xf=x-xi, yf=y-yi, zf=z-zi, xg, yg, zg;
  xf=(3-2*xf)*xf*xf; yf=(3-2*yf)*yf*yf; zf=(3-2*zf)*zf*zf;
  xg=1-xf; yg=1-yf; zg=1-zf;
  return ((n000*zg+n001*zf)*yg+(n010*zg+n011*zf)*yf)*xg+
    ((n100*zg+n101*zf)*yg+(n110*zg+n111*zf)*yf)*xf;
}
static inline float noise2(float x, float y, float z) {
  float v=(noise(x, y, z)+noise(x+100.5, z+100.5, y+100.5))*.5;
  return (3-2*v)*v*v;
}


void domapcoord(Design *o,  
  float ux,float uy,float uz,float u1,  
  float vx,float vy,float vz,float v1) {

  int i, cnt;
  Region *vp, *vt;
  int vpd, vtd;
  char *vpp, *vtp;
  vp=ind_get(o->verts, "pos");
  vt=ind_get(o->verts, "texture");
  cnt=rgn_getsize(vp);
  vpp=rgn_map(vp, 0, cnt, &vpd);
  vtp=rgn_map(vt, 0, cnt, &vtd);
  for (i=0; i<cnt; i++) {
    float *v=(float*)(vpp+i*vpd);
    float *t=(float*)(vtp+i*vtd);
    t[0]=v[0]*ux+v[1]*uy+v[2]*uz+u1;
    t[1]=v[0]*vx+v[1]*vy+v[2]*vz+v1;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vt, vtp);
}


static void lightmul(Design *o, float a, float b) {
  Region *lp=ind_get(o->verts, "light");
  rgn_bfor(lp, float, l)
    l[0]=l[0]*a+b; if (l[0]<0) l[0]=0;
    l[1]=l[1]*a+b; if (l[1]<0) l[1]=0;
    l[2]=l[2]*a+b; if (l[2]<0) l[2]=0;
    l[3]=l[3]*a+b; if (l[3]<0) l[3]=0;
  rgn_efor(lp, l)
}



void vobl(Design *o, float p, float d, float f) {
  int i, vc;
  Region *vp, *vn;
  int vpd, vnd;
  char *vpp, *vnp;
  vp=ind_get(o->verts, "pos");
  vn=ind_get(o->verts, "normal");
  vc=rgn_getsize(vp);
  vpp=rgn_map(vp, 0, vc, &vpd);
  vnp=rgn_map(vn, 0, vc, &vnd);
  for (i=0; i<vc; i++) {
    float *v=(float*)(vpp+i*vpd);
    float *n=(float*)(vnp+i*vnd);
    float k=noise2(v[0]*f+p, v[1]*f, v[2]*f)*d;
    v[0]+=n[0]*k; v[1]+=n[1]*k; v[2]+=n[2]*k;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vn, vnp);
  design_calcnormals(o);
}


float *xlat(float i, float j, float k) {
  static float m[16]={1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1};
  m[12]=i; m[13]=j; m[14]=k;
  return m;
}


//2, 12, 18


static int xtexw=0, xtexh=0;
void view3d(float liti, float kesk, float pekt) {
  float width=640, height=480;
  if (!xtexw) 
    glViewport(0, (height-width*liti)*.5, width, width*liti);
  else
    glViewport(0, 0, xtexw, xtexh);
  glMatrixMode(GL_TEXTURE);
  glLoadIdentity();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-.01, .01, -.01, .01, .01*pekt, 600.0);
  glScalef(1, 1/liti, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_RESCALE_NORMAL);
  glDepthFunc(GL_LEQUAL);
}
void view2d(float liti, float kesk) {
  float width=640, height=480;
  if (!xtexw) 
    glViewport(0, (height-width*liti)*.5, width, width*liti);
  else
    glViewport(0, 0, xtexw, xtexh);
  glMatrixMode(GL_TEXTURE);
  glLoadIdentity();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glScalef(1, 1/liti, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glEnable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_RESCALE_NORMAL);
}

void texbegin(int wid, int hgt) {
  xtexw=wid, xtexh=hgt;
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glViewport(0, 0, wid, hgt);
}
void texend(int texno) {
  glBindTexture(GL_TEXTURE_2D, texno);
  glFinish(); //FUSK! is this really needed?
  glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0,0,0,0, xtexw, xtexh);
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  xtexw=0; xtexh=0;
}
void texblur(int texno, int wid, int hgt, 
  float x0, float y0, float r0, float g0, float b0,
  float x1, float y1, float r1, float g1, float b1,
  float x2, float y2, float r2, float g2, float b2,
  float x3, float y3, float r3, float g3, float b3,
  float x4, float y4, float r4, float g4, float b4) {
  glpushad();
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glViewport(0, 0, wid, hgt);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_TEXTURE);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  x0*=(1./wid); y0*=(1./hgt);
  x1*=(1./wid); y1*=(1./hgt);
  x2*=(1./wid); y2*=(1./hgt);
  x3*=(1./wid); y3*=(1./hgt);
  x4*=(1./wid); y4*=(1./hgt);
  glBindTexture(GL_TEXTURE_2D, texno);
  glDisable(GL_LIGHTING);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND); 
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_ONE, GL_ONE);
  if (r0>0.01||g0>0.01||b0>0.01) {
    glColor4f(r0, g0, b0, 1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(x0+0, y0+1); glVertex2f(-1, 1);
    glTexCoord2f(x0+0, y0+0); glVertex2f(-1, -1);
    glTexCoord2f(x0+1, y0+1); glVertex2f(1, 1);
    glTexCoord2f(x0+1, y0+0); glVertex2f(1, -1);
    glEnd();
  }
  if (r1>0.01||g1>0.01||b1>0.01) {
    glColor4f(r1, g1, b1, 1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(x1+0, y1+1); glVertex2f(-1, 1);
    glTexCoord2f(x1+0, y1+0); glVertex2f(-1, -1);
    glTexCoord2f(x1+1, y1+1); glVertex2f(1, 1);
    glTexCoord2f(x1+1, y1+0); glVertex2f(1, -1);
    glEnd();
  }
  if (r2>0.01||g2>0.01||b2>0.01) {
    glColor4f(r2, g2, b2, 1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(x2+0, y2+1); glVertex2f(-1, 1);
    glTexCoord2f(x2+0, y2+0); glVertex2f(-1, -1);
    glTexCoord2f(x2+1, y2+1); glVertex2f(1, 1);
    glTexCoord2f(x2+1, y2+0); glVertex2f(1, -1);
    glEnd();
  }
  if (r3>0.01||g3>0.01||b3>0.01) {
    glColor4f(r3, g3, b3, 1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(x3+0, y3+1); glVertex2f(-1, 1);
    glTexCoord2f(x3+0, y3+0); glVertex2f(-1, -1);
    glTexCoord2f(x3+1, y3+1); glVertex2f(1, 1);
    glTexCoord2f(x3+1, y3+0); glVertex2f(1, -1);
    glEnd();
  }
  if (r4>0.01||g4>0.01||b4>0.01) {
    glColor4f(r4, g4, b4, 1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(x4+0, y4+1); glVertex2f(-1, 1);
    glTexCoord2f(x4+0, y4+0); glVertex2f(-1, -1);
    glTexCoord2f(x4+1, y4+1); glVertex2f(1, 1);
    glTexCoord2f(x4+1, y4+0); glVertex2f(1, -1);
    glEnd();
  }
  glFinish(); //FUSK! is this really needed?
  glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0,0,0,0, wid, hgt);
  glFinish(); //FUSK! is this really needed?
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glpopad();
}






typedef struct Blk {
  int xr, yr, tr;
  char *data;
  struct Blk *next;
} Blk;

typedef struct {
  int xcnt, ycnt, tcnt, tot;
  Blk *root;
  Blk **data;
} Movie;

Movie *readmovie(FILE *f) {
  int xr, yr, zr, cnt;
  unsigned char pakres;
  Movie *m=malloc(sizeof(Movie));
  Blk **nxt=&m->root;
  m->xcnt=320/16; m->ycnt=240/16; m->tcnt=195; m->tot=0;
  do {
    Blk *b;
    if (fread(&pakres, 1, 1, f)!=1) break;
    if (pakres==255) break;
    b=malloc(sizeof(Blk)); b->tr=pakres/36%7; b->yr=pakres/6%6; b->xr=pakres%6;
    b->data=malloc(1<<b->xr+b->yr+b->tr);
    fread(b->data, 1, 1<<b->xr+b->yr+b->tr, f);
    b->next=0; 
    *nxt=b; nxt=&b->next;
    m->tot++;
  } while (1+1!=3);
  { 
    int i; 
    Blk *b=m->root;
    m->data=malloc(sizeof(Blk*)*m->tot);
    for (i=0; i<m->tot; i++) { if (!b) exit(1); m->data[i]=b, b=b->next; }
  }
  return m;
}

void drawblk(char *buf, int pitch, Blk *b, int xs, int ys, int fno) {
  char *kuv=b->data+(fno<<b->tr>>12<<b->xr+b->yr);
  int xsi=(256<<b->xr)/xs, ysi=(256<<b->yr)/ys, x, y;
//  if (b->xr!=4 || b->yr!=4 || b->tr!=4) exit(1);
  for (y=0; y<ys; y++) {
    for (x=0; x<xs; x++) *buf++=kuv[(y*ysi>>8<<b->xr)+(x*xsi>>8)];
    buf+=pitch-xs;
  }
}

void getframe(char *buf, int pitch, Movie *m, int xs, int ys, int fno) {
  Blk **b0=m->data+((fno>>12)%m->tcnt)*m->ycnt*m->xcnt;
  int xk=xs/m->xcnt, yk=ys/m->ycnt, x, y;
  for (y=0; y<m->ycnt; y++) for (x=0; x<m->xcnt; x++)
    drawblk(buf+y*yk*pitch+x*xk, pitch, b0[y*m->xcnt+x], xk, yk, fno&4095);
}




