

#define EXCREMENT fprintf(stderr, __FILE__ " %i\n", __LINE__);


typedef struct _Stereotype Stereotype;
typedef struct _Individual Individual;
struct _Stereotype {
  char *label;
  void (*slaughter)(Individual *);
};
struct _Individual {
  union { Stereotype *Individual; } norms;
};

#define inv_slaughter(a) ((a)->norms.Individual->slaughter((Individual*)(a)))



typedef struct _Space Space;
struct _Space {
  Stereotype basis;
  void *(*squat)(Space *, int);
  void (*reclaim)(Space *, void **, int);
  void (*abandon)(Space *, void **);
};

#define space_squat(a, b)       ((a)->squat((a), (b)))
#define space_reclaim(a, b, c)  ((a)->reclaim((a), (b), (c)))
#define space_abandon(a, b)     ((a)->abandon((a), (b)))



typedef struct _Cult_st Cult_st;
typedef struct _Cult Cult;
struct _Cult_st {
  Space basis;
  Individual *(*breed)(Cult *, int);
  void (*addritual)(Cult *, Individual *, void (*)(Individual *));
  void (*suicide)(Cult *);
};
struct _Cult {
  union { Stereotype *Individual; Cult_st *Cult; Individual master; } norms;
};




typedef struct _Map_st Map_st;
typedef struct _Map Map;
struct _Map_st {
  Stereotype basis;
  void *(*map)(Map *, int ind, int cnt, int *udelta);
  void (*unmap)(Map *, void *p);
};
struct _Map {
  union { Stereotype *Individual; Map_st *Map; Individual master; } norms;
};



#define map_map(a, b, c, d) ((a)->norms.Map->map((Map*)(a), (b), (c), (d)))
#define map_unmap(a, b)  ((a)->norms.Map->unmap((Map*)(a), (b)))
#define map_bfor(map, typ, var, start, count) { typ *var; int var##_del, var##_cnt=(count); char *var##_beg=map_map(map, (start), var##_cnt, &var##_del), *var##_end=var##_beg+var##_del*var##_cnt; for (var=(typ*)var##_beg; var<(typ*)var##_end; var=(typ*)((char*)var+var##_del)) {
#define map_efor(map, var) } map_unmap(map, var); }





typedef struct _Region_st Region_st;
typedef struct _Region Region;
struct _Region_st {
  Map_st super;
  int (*getsize)(Region *);
  void (*setsize)(Region *, int);
};
struct _Region {
  union { Stereotype *Individual; Map_st *Map; Region_st *Region; Map master; } norms;
};


#define rgn_getsize(a)        ((a)->norms.Region->getsize((a)))
#define rgn_setsize(a, b)     ((a)->norms.Region->setsize((a), (b)))
#define rgn_map(a, b, c, d) (map_map((a), (b), (c), (d)))
#define rgn_unmap(a, b)     (map_unmap((a), (b)))
#define rgn_bfor(rgn, typ, var) map_bfor(rgn, typ, var, 0, rgn_getsize(rgn))
#define rgn_efor(rgn, var) map_efor(rgn, var)



typedef struct _Index_st Index_st;
typedef struct _Index Index;
struct _Index_st {
  Stereotype super;
  void *(*get)(Index *, char *);
  char *(*next)(Index *, char *);
  int (*exists)(Index *, char *);
};
struct _Index {
  union { Stereotype *Individual; Index_st *Index; Individual master; } norms;
};

#define ind_get(a, b)    ((a)->norms.Index->get((a), (b)))
#define ind_next(a, b)   ((a)->norms.Index->next((a), (b)))
#define ind_exists(a, b) ((a)->norms.Index->exists((a), (b)))




typedef struct _Register_st Register_st;
typedef struct _Register Register;
struct _Register_st {
  Index_st super;
  void (*set)(Register *, char *, void *);
  void (*remove)(Register *, char *);
};
struct _Register {
  union { Stereotype *Individual; Index_st *Index; Register_st *Register; Index master; } norms;
};

#define reg_get(a, b)    (ind_get((Index*)(a), (b)))
#define reg_next(a, b)   (ind_next((Index*)(a), (b)))
#define reg_exists(a, b) (ind_exists((Index*)(a), (b)))
#define reg_set(a, b, c) ((a)->norms.Register->set((a), (b), (c)))
#define reg_remove(a, b) ((a)->norms.Register->remove((a), (b)))




typedef struct _Product_st Product_st;
typedef struct _Product Product;
struct _Product_st {
  Stereotype basis;
  void (*export)(Product *, char *);
  void (*import)(Product *, char *);
};
struct _Product {
  union { Stereotype *Individual; Product_st *Product; Individual master; } norms;
};


