#include <SDL/SDL.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <math.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>

GLuint sphereList;
GLuint cubeList;
GLuint texId;
GLuint credId;
GLuint logoId;
unsigned char *pixels;
unsigned char *tmpPixels;
float flt[8192];
float mySin[8192];
float v=0;
int k=0;

int effect=0;

#ifndef M_PI
#define M_PI		3.14159265358979323846
#endif

#define SCREENWIDTH 256
#define SCREENHEIGHT 256

unsigned char fireArray[SCREENWIDTH*SCREENHEIGHT];
int lensArray[SCREENWIDTH*SCREENHEIGHT];
unsigned char destArray[SCREENWIDTH*SCREENHEIGHT*4];

void LensEffect(unsigned char* pixels, int width, int height, float radius) 
{
	//Update the lens
	for (int y=0; y<height; y++)
	{
		for (int x=0; x<width; x++)
		{
			int xnew=(x+(int)((radius/2)-((float) rand()) / ((float) RAND_MAX) * radius))%width;
			int ynew=(y+(int)((radius/2)-((float) rand()) / ((float) RAND_MAX) * (radius)))%height;
	
			if (ynew<0)
			{
				ynew=0;
			}
			if (xnew<0)
			{
				xnew=0;
			}
			lensArray[y*width+x]=ynew*width+xnew;
		}
	}

	//Displacement
	int cnt;
	for (cnt=0; cnt<width*height;cnt++)
	{
		destArray[cnt*4]=pixels[lensArray[cnt]*4];
		destArray[cnt*4+1]=pixels[lensArray[cnt]*4+1];
		destArray[cnt*4+2]=pixels[lensArray[cnt]*4+2];
	}
	memcpy(pixels, destArray, width*height*4);
}


void initFire() {
 unsigned char* pixels = fireArray;
 for (int i = 0; i < SCREENWIDTH*SCREENHEIGHT; i++) {
  *(pixels++) = 0;
 }
}


void FireEffect(unsigned char* pixels, int width, int height, float damp) {
int tmp=(width*(height - 3));
  for(int y = tmp; y >= 0; y-=width){
	// for (int y = 0; y < width*(height-2); y+=width) {
  for (int x = 1; x < width-1; x++) {
   //unsigned char max = pixels[(y + x)*4];
   unsigned char max = fireArray[y + x];
   for (int i = 0; i < 3; i++) {
    unsigned char temp = pixels[(y+x)*4 + i];
    if (temp > max) {
     max = temp;
    }
   }

   unsigned char fire = (unsigned char)((4*max + fireArray[y+width+x] + fireArray[y+width+x-1] +
						 fireArray[y+width+x+1] + fireArray[y+width*2+x] +
						 fireArray[y+width*2+x-1] + fireArray[y+width*2+x+1]) / (10+damp));
   
   fireArray[y+x] = fire;
   if (fire > 0 && fire < 128) {
    pixels[(y+x)*4+0] = fire*2;
    pixels[(y+x)*4+1] = fire;
   } else if (fire > 0) {
    pixels[(y+x)*4+0] = 255;
    pixels[(y+x)*4+1] = fire;
   }
  }
 }
}


void distort(unsigned char* dest, unsigned char* source, int w, int h, float ang, float amp){
  int x1,y1;
  for(int y=0; y<h; y++){
	for(int x=0; x<w; x++){
	  y1=(int)(y+amp*mySin[(30*x+30*y+(int)ang)%8192]);
	  x1=(int)(x+amp*mySin[(50*y+17*x+(int)ang)%8192]);
	  if (y1<0) y1=0;
	  if (y1>h-1) y1=h-1;
	  if (x1<0) x1=0;
	  if (y1>w-1) y1=w-1;
	  *((int*)(dest+(y*w+x)*4))=*((int*)(source+(y1*w+x1)*4));
	}
  }
}

void blur(unsigned char* dest, unsigned char* source, int w, int h, int blurSize, int noise){
  int acc[3];
  int x,y,x1,y1,i;
  float c;
  float r=0;
  int offset, yOffset;
  int afterH=(blurSize+1)*4;
  int beforeH=-blurSize*4;
  float fact=1/(float)(2*blurSize+1);
  for(y=0; y<h; y++){
	for(i=0; i<3; i++) acc[i]=0;
	yOffset=(y*w)<<2;
	for(int x=blurSize; x<w-blurSize; x++){
	  offset=yOffset+(x<<2);
	  r=noise*flt[(k++)%8192]-(noise>>1);
	  for(i=0; i<3; i++){
	    c=acc[i]*fact+r;
		if (c<0) c=0;
		if (c>255) c=255;
		dest[offset+i]=(unsigned char)c;
	  }
	  if (x>blurSize*3){
		for(i=0; i<3; i++) acc[i]+=source[offset+afterH+i]-source[offset+beforeH+i];
		} else {
		for(i=0; i<3; i++) acc[i]+=source[offset+afterH+i];
	  }
	}
  }
}

void init(){
  glClearColor(0, 0, 0, 0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_NORMALIZE);

  GLfloat lightdiffuse[]={1,1,1,1};
  GLfloat lightspecular[]={1,1,1,1};
  GLfloat lightambient[]={0.1,0.1,0.1,1};
  glLightfv(GL_LIGHT0, GL_DIFFUSE, lightdiffuse);
  glLightfv(GL_LIGHT0, GL_AMBIENT, lightambient);
  glLightfv(GL_LIGHT0, GL_SPECULAR, lightspecular);
  glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 0.0);
  glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.1);
  glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.0);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);

  glEnable(GL_TEXTURE_2D);

  SDL_Surface *image = SDL_LoadBMP("logo.bmp");
  if ( image == NULL ) {
	fprintf(stderr, "Couldn't load image logo.bmp\n", SDL_GetError());
	return;
  }
  glGenTextures(1, &logoId);
  glBindTexture(GL_TEXTURE_2D, logoId);
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, image->w, image->h, 0, GL_BGR, GL_UNSIGNED_BYTE, image->pixels);

  image = SDL_LoadBMP("cred.bmp");
  if ( image == NULL ) {
	fprintf(stderr, "Couldn't load image cred.bmp\n", SDL_GetError());
	return;
  }
  glGenTextures(1, &credId);
  glBindTexture(GL_TEXTURE_2D, credId);
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, image->w, image->h, 0, GL_BGR, GL_UNSIGNED_BYTE, image->pixels);

  glGenTextures(1, &texId);
  glBindTexture(GL_TEXTURE_2D, texId);
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glShadeModel(GL_SMOOTH);

  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

  sphereList=glGenLists(1);
  glNewList(sphereList, GL_COMPILE);
  GLUquadricObj *qObj=gluNewQuadric();
  gluSphere(qObj, 1.0, 14,8);
  glEndList();

  cubeList=glGenLists(1);
  glNewList(cubeList, GL_COMPILE);
  glBegin(GL_QUADS);

  glNormal3f(0,0,1);
  glVertex3f(1,1,1);
  glVertex3f(-1,1,1);
  glVertex3f(-1,-1,1);
  glVertex3f(1,-1,1);

  glNormal3f(0,0,-1);
  glVertex3f(1,-1,-1);
  glVertex3f(-1,-1,-1);
  glVertex3f(-1,1,-1);
  glVertex3f(1,1,-1);

  glNormal3f(-1,0,0);
  glVertex3f(-1,-1,-1);
  glVertex3f(-1,-1,1);
  glVertex3f(-1,1,1);
  glVertex3f(-1,1,-1);

  glNormal3f(1,0,0);
  glVertex3f(1,1,-1);
  glVertex3f(1,1,1);
  glVertex3f(1,-1,1);
  glVertex3f(1,-1,-1);

  glNormal3f(0,-1,0);
  glVertex3f(1,-1,-1);
  glVertex3f(1,-1,1);
  glVertex3f(-1,-1,1);
  glVertex3f(-1,-1,-1);

  glNormal3f(0,1,0);
  glVertex3f(-1,1,-1);
  glVertex3f(-1,1,1);
  glVertex3f(1,1,1);
  glVertex3f(1,1,-1);

  glEnd();
  glEndList();

}


void drawSceneCheckers(float light){
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.56, 0.56, 2.0, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, 1, -11.0);

  GLfloat pos[]={40*sin(v*0.01),30*sin(v*0.02),10,0};
  glLightfv(GL_LIGHT0, GL_POSITION, pos);


  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glDisable(GL_TEXTURE_2D);
  glEnable(GL_LIGHTING);
  
  glRotatef(175,1,0,0);
  
  GLfloat white[]={light*0.8,light*0.8,light*0.7,1};
  GLfloat yellow[]={light*0.6,light*0.5,light*0.3,1};
  GLfloat black[]={0,0,0,1};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  glMaterialfv(GL_FRONT, GL_AMBIENT, yellow);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, white);
  glMateriali(GL_FRONT, GL_SHININESS, 40);

  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glDisable(GL_DEPTH_TEST);
  {
	float s;
	float x,y,z;
	for(int i=0; i<300; i++){
	  x=1.1*sin(0.035*i+v*0.01);
	  y=0.5*sin(0.022*i+v*0.02)+0.9;
	  z=3*sin(i*0.033+v*0.023);
	  glPushMatrix();
	  glTranslatef(x,-y,z);
	  s=0.1*sin(0.04*i)+0.2;
	  glScalef(s,s,s);
	  glCallList(sphereList);
	  glPopMatrix();
	}
  }
  
  GLfloat gray[]={light*0.4,light*0.4,light*0.4,0.7};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, gray);
  glMaterialfv(GL_FRONT, GL_AMBIENT, gray);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, black);
  glMateriali(GL_FRONT, GL_SHININESS, 1);

  glBegin(GL_QUADS);
  int x,y,z;
  for(z=-4;z<14;z++){
	for(x=-4;x<4;x++){
	  glVertex3f(x+0.5,0,z);
	  glVertex3f(x,0,z);
	  glVertex3f(x,0,z+0.5);
	  glVertex3f(x+0.5,0,z+0.5);
	  
	  glVertex3f(x+1,0,z+0.5);
	  glVertex3f(x+0.5,0,z+0.5);
	  glVertex3f(x+0.5,0,z+1);
	  glVertex3f(x+1,0,z+1);
	}
  }
  GLfloat dark[]={0,0,0,0.4};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, dark);
  glMaterialfv(GL_FRONT, GL_AMBIENT, dark);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, black);
  glMateriali(GL_FRONT, GL_SHININESS, 1);

  glBegin(GL_QUADS);
  for(z=-4;z<14;z++){
	for(x=-4;x<4;x++){
	  glVertex3f(x+1,0,z+0);
	  glVertex3f(x+0.5,0,z+0);
	  glVertex3f(x+0.5,0,z+0.5);
	  glVertex3f(x+1,0,z+0.5);
	  
	  glVertex3f(x+0,0,z+1);
	  glVertex3f(x+0.5,0,z+1);
	  glVertex3f(x+0.5,0,z+0.5);
	  glVertex3f(x+0,0,z+0.5);
	}
  }
  glEnd();

  glDisable(GL_BLEND);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  glMaterialfv(GL_FRONT, GL_AMBIENT, yellow);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, white);
  glMateriali(GL_FRONT, GL_SHININESS, 40);
  {
	float s;
	float x,y,z;
	for(int i=0; i<300; i++){
	  x=1.1*sin(0.035*i+v*0.01);
	  y=0.5*sin(0.022*i+v*0.02)+0.9;
	  z=3*sin(i*0.033+v*0.023);
	  glPushMatrix();
	  glTranslatef(x,y,z);
	  s=0.1*sin(0.04*i)+0.2;
	  glScalef(s,s,s);
	  glCallList(sphereList);
	  glPopMatrix();
	}
  }
  v++;
}


void drawScene(float size, float light){
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.56, 0.56, 2.0, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, 0, -30.0-10*sin(v*0.008));
 
  GLfloat pos[]={40*sin(v*0.00),30*sin(v*0.00),10,0};
  glLightfv(GL_LIGHT0, GL_POSITION, pos);

  GLfloat white[]={light*0.7,light*0.6,light*0.4,1};
  GLfloat yellow[]={light*0.6,light*0.5,light*0.3,1};
  GLfloat black[]={0,0,0,1};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  glMaterialfv(GL_FRONT, GL_AMBIENT, yellow);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, white);
  glMateriali(GL_FRONT, GL_SHININESS, 10);

  glEnable(GL_DEPTH_TEST);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glEnable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glPushMatrix();
  glRotatef(0.52*v++,1,0,0);
  glRotatef(0.32*v++,0,1,0);
  for(int z=-3; z<=3; z++){
	for(int y=-3; y<=3; y++){
	  for(int x=-3; x<=3; x++){
		glPushMatrix();
		glTranslatef(x,y,z);
		glScalef(size,size,size);
		glCallList(cubeList);
		glPopMatrix();
	  }
	}
  }
  glPopMatrix();
  glFlush();
}

void drawPsycho(float light, float feedback){
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  glDisable(GL_LIGHTING);
  glDisable(GL_BLEND);

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, texId);
  glColor4f(feedback,feedback,feedback,1);
  glScalef(0.4+0.0*sin(v*0.016),0.52+0.0*sin(v*0.034),0);
  glBegin(GL_QUADS);
  glTexCoord2f(1,1);
  glVertex3f(1.05,1.05,0);
  glTexCoord2f(0,1);
  glVertex3f(-1.05,1.05,0);
  glTexCoord2f(0,0);
  glVertex3f(-1.05,-1.05,0);
  glTexCoord2f(1,0);
  glVertex3f(1.05,-1.05,0);
  glEnd();
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.56, 0.56, 2.0, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, 0, -40.0-30*sin(v*0.008));
 
  GLfloat pos[]={40*sin(v*0.01),30*sin(v*0.02),10,0};
  glLightfv(GL_LIGHT0, GL_POSITION, pos);

  GLfloat white[]={light*0.9,light*1,light*0.9,1};
  GLfloat yellow[]={light*0.5,light*0.6,light*0.7,1};
  GLfloat black[]={0,0,0,1};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  glMaterialfv(GL_FRONT, GL_AMBIENT, yellow);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, white);
  glMateriali(GL_FRONT, GL_SHININESS, 40);
  glEnable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glPushMatrix();
  glRotatef(0.312*v++,1,0,0);
  glRotatef(0.211*v++,0,1,0);

  glClear(GL_DEPTH_BUFFER_BIT);

  for(int z=-3; z<=3; z++){
	for(int y=-3; y<=3; y++){
	  for(int x=-3; x<=3; x++){
		glPushMatrix();
		glTranslatef(x,y,z);
		glScalef(z*0.15,y*0.15,x*0.15);
		glCallList(sphereList);
		glPopMatrix();
	  }
	}
  }

  //  glPushMatrix();
  //glScalef(1,1,1);
  //glCallList(cubeList);
  //  glPopMatrix();
  
  glPopMatrix();
  glFlush();
}


void drawSceneNystan(int length, float q){
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.56, 0.56, 2.0, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, 0, -20.0-10*sin(v*0.004));
 
  GLfloat pos[]={40*sin(v*0.005),30*sin(v*0.008),10,0};
  glLightfv(GL_LIGHT0, GL_POSITION, pos);

  GLfloat white[]={1,1,0.9,1};
  GLfloat yellow[]={0.6,0.5,0.3,1};
  GLfloat black[]={0,0,0,1};
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  glMaterialfv(GL_FRONT, GL_AMBIENT, yellow);
  glMaterialfv(GL_FRONT, GL_EMISSION, black);
  glMaterialfv(GL_FRONT, GL_SPECULAR, white);
  glMateriali(GL_FRONT, GL_SHININESS, 40);

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glEnable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glPushMatrix();
  glRotatef(0.12*v++,1,0,0);
  glRotatef(0.11*v++,0,1,0);
  int i;
  glBegin(GL_LINE_STRIP);
  float x,y,z;
  for(i=0; i<length; i++){
   	x=mySin[(int)(i*q*0.2)%8192]*4*mySin[(int)(i*10)%8192];
   	y=mySin[(int)(i*q*0.08)%8192]*4*mySin[(int)(i*29)%8192];
   	z=mySin[(int)(i*q*0.07)%8192]*4*mySin[(int)(i*39)%8192];
	glNormal3f(x,y,z);
	glVertex3f(x,y,z);
  }
  glEnd();
  glPopMatrix();
  glFlush();
}


void drawWhiteBoard(float alpha){
  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glColor4f(1,1,1,alpha);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  
  glBegin(GL_QUADS);
  glVertex3f(1,1,0);
  glVertex3f(-1,1,0);
  glVertex3f(-1,-1,0);
  glVertex3f(1,-1,0);
  glEnd();
}

void drawLogo(float ang, float alpha){
  glClearColor(1,1,1,0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.56, 0.56, 2.0, 500.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0, 0, -20);

  glRotatef(ang,0,1,0);
  glScalef(3,3,3);

  glDisable(GL_LIGHTING);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glBindTexture(GL_TEXTURE_2D, logoId);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  glColor4f(1,1,1,alpha);

  glBegin(GL_QUADS);
  glTexCoord2f(0,1);
  glVertex3f(1.05,1,0);
  glTexCoord2f(1,1);
  glVertex3f(-1.05,1,0);
  glTexCoord2f(1,0);
  glVertex3f(-1.05,-1,0);
  glTexCoord2f(0,0);
  glVertex3f(1.05,-1,0);
  glEnd();
  
  glClearColor(0,0,0,1);
}

void drawCred(float alpha){
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  glDisable(GL_LIGHTING);
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D, credId);
  glColor4f(1,1,1,alpha);

  glScalef(0.7,0.9,0.5);
  glBegin(GL_QUADS);
  glTexCoord2f(0,1);
  glVertex3f(0.5,0.5,0);
  glTexCoord2f(1,1);
  glVertex3f(-0.5,0.5,0);
  glTexCoord2f(1,0);
  glVertex3f(-0.5,-0.5,0);
  glTexCoord2f(0,0);
  glVertex3f(0.5,-0.5,0);
  glEnd();
  
  glClearColor(0,0,0,1);
}

void drawOverSizePoly(){
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glBindTexture(GL_TEXTURE_2D, texId);
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_LIGHTING);
  glDisable(GL_BLEND);
  glBegin(GL_QUADS);
  glTexCoord2f(0,0);
  glVertex3f(1.05,1,0);
  glTexCoord2f(1,0);
  glVertex3f(-1.05,1,0);
  glTexCoord2f(1,1);
  glVertex3f(-1.05,-1,0);
  glTexCoord2f(0,1);
  glVertex3f(1.05,-1,0);
  glEnd();
}

float getClock(){
  return clock()/(float)CLOCKS_PER_SEC;
}
void grabScreen(){
  glReadPixels(192,112,256,256, GL_RGBA, GL_UNSIGNED_BYTE, tmpPixels);
}
void genTexture(unsigned char *buffer){
  glBindTexture(GL_TEXTURE_2D, texId);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 256, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
}

#define FX_0 35.0
#define FX_1 51.0
#define FX_2 88.0
#define FX_3 106.0
#define FX_4 124.0

void display() {
  float tmp, dist, lines, fxl;
  switch(effect){
  case 0:
	drawPsycho(getClock()/(float)FX_0*3, sqrt(getClock()/(float)FX_0));
  	drawWhiteBoard(FX_0-getClock()<5 ? 1-(FX_0-getClock())/5 : 0);
	grabScreen();
	drawOverSizePoly();
	blur(pixels, tmpPixels, 256, 256, 2, 10);
	genTexture(pixels);
	if (getClock()>FX_0) effect=1;
	break;
  case 1:	
	tmp=getClock()-FX_0;
	fxl=FX_1-FX_0;
	drawLogo(2*(tmp*4-20), (tmp<fxl/2?tmp/(fxl/2):(fxl-tmp)/(fxl/2)));
	grabScreen();
	LensEffect(tmpPixels, 256, 256, (tmp>fxl/2?(tmp-fxl/2)*2+1:0));
	genTexture(tmpPixels);
	if (getClock()>FX_1) effect=2;
	break;
  case 2:	
	tmp=getClock()-FX_1-10;
	dist=(tmp>0?tmp:0);
	drawSceneCheckers(FX_2-getClock()<10?(FX_2-getClock())/10.0:1);
  	drawWhiteBoard(getClock()-FX_1<6 ? 1-(getClock()-FX_1)/5 : 0);
	grabScreen();
	distort(pixels, tmpPixels, 256, 256, dist*3000, dist);
	blur(tmpPixels, pixels, 256, 256, (tmp<0?(10+(int)tmp)/2:10)/4+2, 10);
	genTexture(tmpPixels);
	if (getClock()>FX_2) effect=3;
	
	//drawScene(0.001*v>0.4?0.4:0.001*v, 1);
	//Modify framebuffer
	//distort(pixels, tmpPixels, 256, 256,v*80);
	//blur(tmpPixels, pixels, 256, 256, 2, 10);
	break;
  case 3:
    tmp=getClock()-FX_2;
	lines=0;
	if (tmp<10) lines=tmp*500+300;
	else if (FX_3-getClock()<10.0) lines=(FX_3-getClock())*500+300;
	else lines=5300;
									
	drawSceneNystan((int)lines, tmp);
	grabScreen();
	FireEffect(tmpPixels, 256, 256, 0.2);
	genTexture(tmpPixels);
	if (getClock()>FX_3) effect=4;
	break;
  case 4:
    tmp=getClock()-FX_3;
	drawScene((tmp*0.05<0.45?tmp*0.05:0.4), (FX_4-getClock()<10.0 ? (FX_4-getClock())/10.0 : 1));
	grabScreen();
	FireEffect(tmpPixels, 256, 256, 3.0/(tmp+5));
	genTexture(tmpPixels);
	if (getClock()>FX_4) effect=5;
	break;
  case 5:
    tmp=getClock()-FX_4;
	drawCred(1);
	grabScreen();
	genTexture(tmpPixels);
  }

  drawOverSizePoly();
  SDL_GL_SwapBuffers();
}

void handleChildTerm( int a){
	union wait wstatus;
	while (wait3(&wstatus, WNOHANG, NULL) > 0);
}

int main(int argc, char *argv[]) {
  	SDL_Surface *screen;

	signal(SIGCHLD, handleChildTerm);
	signal(SIGHUP, SIG_IGN);
	pid_t pid=fork();
	if (pid==-1) exit(-1);
	if (pid==0){
	  execlp("mpg123", "mpg123", "-q", "muzak.mp3", NULL);
	  exit(0);
	}

  	if(SDL_Init(SDL_INIT_VIDEO) < 0 ){
    	fprintf(stderr, "Couldn't initialize SDL: %s\n", SDL_GetError());
    	exit(1);
	}

  	atexit(SDL_Quit);

  	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1);
  	SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16);

  	if( (screen = SDL_SetVideoMode( 640, 480, 32, SDL_OPENGL | SDL_FULLSCREEN)) == NULL ) {
    	fprintf(stderr, "Couldn't set GL mode: %s\n", SDL_GetError());
    	exit(1);
  	}

	SDL_ShowCursor(SDL_DISABLE);

	int i;
	for(i=0; i<8192; i++) flt[i]=rand()/(float)RAND_MAX;
	for(i=0; i<8192; i++) mySin[i]=sin(2*M_PI*i/(float)8192);

	init();
	initFire();

	pixels=new unsigned char[screen->w*screen->h*4];
	tmpPixels=new unsigned char[screen->w*screen->h*4];
	float v=0;		
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	SDL_GL_SwapBuffers();
	grabScreen();

 	while(1) {
    	SDL_Event event;
    	while(SDL_PollEvent(&event)) {
			if(event.type == SDL_MOUSEBUTTONDOWN) {
			}
			if(event.type == SDL_MOUSEMOTION) {
			}
			if(event.type == SDL_KEYDOWN) {
				switch(event.key.keysym.sym) {
					case SDLK_ESCAPE: {
					  kill(pid, 3);
					  SDL_ShowCursor(SDL_ENABLE);
					  exit(0); 
					  break;
					}
				}
    		}
    	}
    	display();
  	}
	return 0;
}


