// Trail effect
#ifndef __TRAILEFFECT_H
#define __TRAILEFFECT_H
#include <vector>
#include "effect.h"

class TrailEffect : public Effect
{
public:
	struct Trail
	{
		int texId;
		float ang, angAdd;
		float x, y, z;
	};
	typedef std::vector< Trail > TrailList;
	
	
	
	TrailEffect();
	virtual ~TrailEffect();

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update();

	// Renders the effects current frame
	virtual void render();

private:
	// The timeout counter
	int myTimeout;

	// List of all active trails
	TrailList myTrails;
	// List of all trail smokes
	TrailList mySmokes;

	// Smoke add pause
	int mySmokePause;
	
	// Effect ending?
	bool myEnding;
};

#endif
