// Particle-based text viewer
#ifndef __TEXTVIEW_H
#define __TEXTVIEW_H

// Initializes the text view
void textviewInit();

// Clears all the text
void textviewClear();

// Removes a certain item from the screen
void textviewRemove( int id );

// Returns the text width/height
int textviewWidth( const char *text, int zoom = 1 );
int textviewHeight( const char *text, int zoom = 1 );

// Adds text to the view (returns an unique id)
int textviewWrite( const char *text, int x, int y, int zoom = 1 );

// Updates the textview for one frame
void textviewUpdate();

// Renders the textview
void textviewRender();

// Renders one text
void textviewRender( const char *text, int x, int y, int zoom = 1 );

#endif
