#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "GL/gl.h"
#include "GL/glut.h"

#include "font.h"
#include "textures.h"

// tAAt textures
unsigned int taatColor[ 3 ] = { 0, 0, 0 };

// Greet textures
unsigned int textureGreet = 0;
unsigned int *textureGreetCLUT = 0;

unsigned int textureGreetFloor = 0;
unsigned int *textureGreetFloorCLUT = 0;

// Textview texture
unsigned int textviewTexture = 0;

// Pipe texture
unsigned int texturePipe = 0;
unsigned int *texturePipeCLUT = 0;

// Trail textures
unsigned int textureTrail = 0;

////////

typedef unsigned char UInt8;


// Creates the taat colors
static void createTaatColors();
// Creates the greet texture
static void createGreetTexture();
// Creates the textview texture
static void createTextviewTexture();
// Creates the pipe texture
static void createPipeTexture();
// Creates the trail texture
static void createTrailTexture();

////////

// Initializes the textures
void initTextures()
{
	createTaatColors();
	createGreetTexture();
	createTextviewTexture();
	createPipeTexture();
	createTrailTexture();
}

// Activates a texture (+ a given CLUT; optional)
void setTexture( unsigned int texId, unsigned int *clut )
{
	if ( texId <= 0 )
	{
		glDisable( GL_TEXTURE_2D );
		return;
	}

	glEnable( GL_TEXTURE_2D );
	glBindTexture( GL_TEXTURE_2D, texId );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, /*GL_REPLACE*/GL_MODULATE );

	if ( clut != 0 )
		glColorTable( GL_COLOR_TABLE, GL_RGBA, 256, GL_RGBA, GL_UNSIGNED_INT_8_8_8_8, clut );
}

////////

// Creates a constant color texture
static unsigned int createConstantTexture( int a, int r, int g, int b )
{
	int wh = 8;
	unsigned int id;

	glGenTextures( 1, &id );
	glBindTexture( GL_TEXTURE_2D, id );

	// Fill the texture
	unsigned int *data = ( unsigned int * ) pglutAllocDmaMem( wh * wh * sizeof( unsigned int ) );

	unsigned int col = ( a << 24 ) | ( b << 16 ) | ( g << 8 ) | ( r << 0 );

	int left = wh * wh;
	unsigned int *pos = data;
	while ( left-- > 0 )
		*pos++ = col;

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, wh, wh, 0, GL_RGBA, GL_UNSIGNED_BYTE, data );
	return id;
}

// Increases a value and clamps to 255
static inline void inc( UInt8 &val, UInt8 amt )
{
	int tmp = ( ( int ) val ) + amt;
	val = ( tmp > 0xff ) ? 0xff : ( UInt8 ) tmp;
}

// Wraps a value to [0,x[ range
static inline int wrap( int val, int range )
{
	while ( val < 0 )
		val += range;
	while ( val >= range )
		val -= range;
	return val;
} 

////////

// Creates the taat colors
static void createTaatColors()
{
	taatColor[ 0 ] = createConstantTexture( 100, 105,  40,  80  );
	taatColor[ 1 ] = createConstantTexture( 100,  25,  20, 130  );
	taatColor[ 2 ] = createConstantTexture( 100,  70,  30, 100  );
}

// Creates the greet textures
static void createGreetTexture()
{
	int i;

	textureGreetCLUT = ( unsigned int * ) pglutAllocDmaMem( sizeof( int ) * 256 );
	textureGreetFloorCLUT = ( unsigned int * ) pglutAllocDmaMem( sizeof( int ) * 256 );

	// Create the CLUT palette
	for ( i = 0; i < 256; ++i )
	{
		float t = ( float ) i / 255.f;
		UInt8 r = ( UInt8 ) ( 40 + t * 40 );
		UInt8 g = ( UInt8 ) ( 140 + t * 100 );
		UInt8 b = ( UInt8 ) ( 80 + t * 140 );
		UInt8 a = 0xff;

		textureGreetCLUT[ i ] = ( a << 24 ) | ( b << 16 ) | ( g << 8 ) | ( r << 0 );
	}

	for ( i = 0; i < 256; ++i )
	{
		UInt8 r, g, b;
		UInt8 a = 70;

		if ( ( i & 1 ) == 0 )
		{
			r = 220;
			g = 150;
			b = 55;
		}
		else
		{
			r = 190;
			g = 120;
			b = 25;
		}

		textureGreetFloorCLUT[ i ] = ( a << 24 ) | ( b << 16 ) | ( g << 8 ) | ( r << 0 );
	}

	// Create the texture
	int width = 64;
	int height = 64;

	glGenTextures( 1, &textureGreet );
	glBindTexture( GL_TEXTURE_2D, textureGreet );

	UInt8 *data = ( UInt8 * ) pglutAllocDmaMem( width * height );

	// Fill the texture
	int idx = 0;
	for ( int y = 0; y < height; ++y )
		for ( int x = 0; x < width; ++x )
		{
			float xRad = ( ( float ) x ) * 3.14159f / 180.f;
			float yRad = ( ( float ) y ) * 3.14159f / 180.f;
			float val = ( cosf( yRad * 3 ) + cosf( xRad * 4 ) * 2.f + cosf( yRad + xRad ) ) / 4.f;

			data[ idx++ ] = ( UInt8 ) ( 128 + ( int ) ( val * 127.f ) );
		}

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, width, height, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, data );

	////////

	// Create the texture
	width = 128;
	height = 128;

	glGenTextures( 1, &textureGreetFloor );
	glBindTexture( GL_TEXTURE_2D, textureGreetFloor );

	data = ( UInt8 * ) pglutAllocDmaMem( width * height );

	// Fill the texture
	idx = 0;
	for ( int y = 0; y < height; ++y )
		for ( int x = 0; x < width; ++x )
		{
			int val = ( ( x ^ y ) >> 4 ) & 1;

			data[ idx++ ] = ( UInt8 ) val;
		}

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, width, height, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, data );
}

// Creates the textview texture
static void createTextviewTexture()
{
//	textviewTexture = createConstantTexture( 70, 235, 235, 235 );

	const int width = 16;
	const int height = 16;

	glGenTextures( 1, &textviewTexture );
	glBindTexture( GL_TEXTURE_2D, textviewTexture );

	unsigned int *data = ( unsigned int * ) pglutAllocDmaMem( width * height * sizeof( unsigned int ) );

	// Create the data
	int cx = width / 2;
	int cy = height / 2;

	const float r = 0.7f;
	const float g = 0.8f;
	const float b = 0.7f;
	const float a = 0.7f;

	unsigned int *dest = data;
	for ( int y = 0; y < height; ++y )
	{
		for ( int x = 0; x < width; ++x )
		{
			int dx = cx - x;
			int dy = cy - y;
			float mul = 1 - sqrtf( dx * dx + dy * dy ) / ( float ) cx;

			if ( mul < 0 ) mul = 0;

			UInt8 ir = ( UInt8 ) ( 255.f * mul * r );
			UInt8 ig = ( UInt8 ) ( 255.f * mul * g );
			UInt8 ib = ( UInt8 ) ( 255.f * mul * b );
			UInt8 ia = ( UInt8 ) ( 127.f * mul * a );

			*dest++ = ( ia << 24 ) | ( ib << 16 ) | ( ig << 8 ) | ( ir << 0 );
		}
	}

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data );
}

// Creates the pipe texture
static void createPipeTexture()
{
	texturePipeCLUT = ( unsigned int * ) pglutAllocDmaMem( sizeof( int ) * 256 );

	// Create the CLUT palette
	for ( int i = 0; i < 256; ++i )
	{
		float t = ( float ) i / 255.f;
		UInt8 r = ( UInt8 ) ( 30 + t * 224 );
		UInt8 g = ( UInt8 ) ( 30 + t * 224 );
		UInt8 b = ( UInt8 ) ( 30 + t * 224 );
		UInt8 a = 0xff;

		texturePipeCLUT[ i ] = ( a << 24 ) | ( b << 16 ) | ( g << 8 ) | ( r << 0 );
	}

	// Create the texture
	int width = 64;
	int height = 64;

	glGenTextures( 1, &texturePipe );
	glBindTexture( GL_TEXTURE_2D, texturePipe );

	UInt8 *data = ( UInt8 * ) pglutAllocDmaMem( width * height );

	// Fill the texture
	int left = width * height * 2;
	while ( left-- > 0 )
	{
		int x = rand() % width;
		int y = rand() % height;
		int idx = x + ( y * width );

		inc( data[ idx ], 2 );
		inc( data[ wrap( x - 1, width ) + y * width ], 1 );
		inc( data[ wrap( x + 1, width ) + y * width ], 1 );
		inc( data[ x + wrap( y - 1, height ) * width ], 1 );
		inc( data[ x + wrap( y + 1, height ) * width ], 1 );
	}

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, width, height, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, data );
}

// Creates the trail texture
static void createTrailTexture()
{
	const int width = 128;
	const int height = 128;
	const int bWidth = width / 2;
	const int bHeight = height / 2;

	glGenTextures( 1, &textureTrail );
	glBindTexture( GL_TEXTURE_2D, textureTrail );

	unsigned int *data = ( unsigned int * ) pglutAllocDmaMem( width * height * sizeof( unsigned int ) );

	for ( int tex = 0; tex < 4; ++tex )
	{
		int ux = ( tex == 0 || tex == 1 ) ? 0 : bWidth;
		int uy = ( tex == 1 || tex == 2 ) ? 0 : bHeight;
		int cx = bWidth / 2;
		int cy = bHeight / 2;

		float r = ( tex == 0 ) ? 1.f : 0.3f;
		float g = ( tex == 1 ) ? 1.f : 0.3f;
		float b = ( tex == 2 ) ? 1.f : 0.3f;
		float a = 0.6f;

		if ( tex == 3 ) { r = g = b = 0.5f; }

		for ( int y = 0; y < bHeight; ++y )
		{
			unsigned int *dest = data + ux + ( uy + y ) * width;

			for ( int x = 0; x < bWidth; ++x )
			{
				int dx = cx - x;
				int dy = cy - y;
				float mul = 1 - sqrtf( dx * dx + dy * dy ) / ( float ) cx;

				if ( mul < 0 ) mul = 0;

				UInt8 ir = ( UInt8 ) ( 255.f * mul * r );
				UInt8 ig = ( UInt8 ) ( 255.f * mul * g );
				UInt8 ib = ( UInt8 ) ( 255.f * mul * b );
				UInt8 ia = ( UInt8 ) ( 127.f * mul * a );

				*dest++ = ( ia << 24 ) | ( ib << 16 ) | ( ig << 8 ) | ( ir << 0 );
			}
		}
	}

	// Set the texture
	glTexImage2D( GL_TEXTURE_2D, 0, 3, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data );
}
