#include <stdlib.h>
#include "GL/gl.h"

#include "boxscreffect.h"
#include "miscrender.h"
#include "taateffect.h"
#include "textures.h"
#include "textview.h"

#define BOXAMOUNT 2000
#define BOXPAUSE 10

// Returns a random float [-1,1]
static inline float getRandom()
{
	return ( float ) ( ( rand() % 20001 ) - 10000 ) / 10000.f;
}

////////

TaatEffect::TaatEffect():
	myState( State_Start ), myStatePause( 0 ), myBoxesLeft( 0 ), myBoxPause( 0 )
{
	textviewClear();

	glClearColor( 0.01f, 0.01f, 0.08f, 0.0f );
	initLight( 0, 0, 0, -10, 255, 170, 155 );
}

TaatEffect::~TaatEffect()
{
}

// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
Effect *TaatEffect::update()
{
	if ( myStatePause-- <= 0 )
	{ // New state
		switch ( myState )
		{
			case State_Start:
				myState = State_Wait;
				myStatePause = 0;
				break;

			case State_Wait:
				{
					myState = State_Taat1;
					myStatePause = 400;
				}
				break;

			case State_Taat1:
				{
					myState = State_Taat2;
					myStatePause = 200;

					textviewClear();

					const char *text = "tAAt esittelee";
					textviewWrite( text, ( 640 - textviewWidth( text, 4 ) ) / 2, 100, 4 );
				}
				break;

			case State_Taat2:
				{
					myState = State_TaatWait1;
					myStatePause = 230;

					const char *text = "tAAt presents";
					textviewWrite( text, ( 620 - textviewWidth( text, 3 ) ), 460 - textviewHeight( text, 3 ), 3 );
				}
				break;

			case State_TaatWait1:
				myState = State_TaatWait2;
				myStatePause = 100;

				textviewClear();
				break;

			case State_TaatWait2:
				myState = State_Logo1;
				myStatePause = 200;

				myBoxesLeft = BOXAMOUNT;
				break;

			case State_Logo1:
				{
					myState = State_Logo1b;
					myStatePause = 90;

					const char *text = "nin tehdn";
					textviewWrite( text, ( 640 - textviewWidth( text, 4 ) ) / 2, 100, 4 );
				}
				break;

			case State_Logo1b:
				{
					myState = State_Logo2;
					myStatePause = 250;

					const char *text = "lAAtukaurAA";
					textviewWrite( text, ( 640 - textviewWidth( text, 4 ) ) / 2, 100 + textviewHeight( text, 4 ), 4 );
				}
				break;

			case State_Logo2:
				{
					myState = State_Logo2b;
					myStatePause = 90;

					const char *text = "quAlity oAt";
					textviewWrite( text, ( 620 - textviewWidth( text, 3 ) ), 460 - textviewHeight( text, 3 ) * 2, 3 );
				}
				break;

			case State_Logo2b:
				{
					myState = State_EndStart;
					myStatePause = 300;

					const char *text = "for dummies";
					textviewWrite( text, ( 620 - textviewWidth( text, 3 ) ), 460 - textviewHeight( text, 3 ), 3 );
				}
				break;

			case State_EndStart:
				myState = State_EndWait;
				myStatePause = 999999;
				myBoxesLeft = 0;

				textviewClear();
				break;

			case State_EndWait:
				myStatePause = 999999;
				textviewClear();
				break;
		}
	}

	// Add a box?
	if ( myBoxesLeft > 0 &&
	     myBoxPause-- <= 0 )
	{
		Box box;

		box.texId = taatColor[ myBoxesLeft % 3 ];
		box.x = 0;
		box.y = 4.f;
		box.vx = getRandom() / 30.f;
		box.vy = -0.05f;
		box.ang = getRandom() * 360.f;
		box.angAdd = 0.2 + fabs( getRandom() );

		if ( getRandom() < 0 )
			box.angAdd = -box.angAdd;

		myBoxes.push_back( box );

		--myBoxesLeft;
		myBoxPause = BOXPAUSE;
	}

	// Update the boxes
	int size = myBoxes.size();
	for ( int i = 0; i < size; ++i )
	{
		Box &box = myBoxes[ i ];

		box.x += box.vx;
		box.y += box.vy;
		box.vx = box.vx * 0.995f;
		box.ang += box.angAdd;

		if ( box.y < -4.f )
			box.deleted = true;
	}

	// Remove the deleted boxes
	BoxList::iterator pos = myBoxes.begin();
	BoxList::iterator end = myBoxes.end();
	
	while ( pos != end )
	{
		if ( pos->deleted )
		{
			myBoxes.erase( pos );
			pos = myBoxes.begin();
			end = myBoxes.end();
		}
		else
		{
			++pos;
		}
	}

	// Done?
	if ( myState == State_EndWait &&
	     myBoxes.size() <= 0 )
	{
		return new BoxScrEffect();
	}

	return this;
}

// Renders the effects current frame
void TaatEffect::render()
{
	glRotatef( -60, 0, 0, 1 );

	glEnable( GL_LIGHTING );
	glEnable( GL_BLEND );
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

	int size = myBoxes.size();
	for ( int i = size - 1; i >= 0; --i )
	{
		const Box &box = myBoxes[ i ];

		setTexture( box.texId );

		glPushMatrix();
		glTranslatef( box.x, box.y, -7.f );
		glRotatef( box.ang, 1, 0, 0 );
		glRotatef( box.ang * 0.7f, 0, 1, 0 );
		glRotatef( box.ang * 1.3f, 0, 0, 1 );
		drawBox();
		glPopMatrix();
	}
}
