#include "GL/gl.h"

#include "miscrender.h"

// Box display list
static int boxDisplayList = 0;

////////

// Inits the misc renderer
void initMisc()
{
	boxDisplayList = glGenLists( 1 );
	glNewList( boxDisplayList, GL_COMPILE );
	static float points[ 8 ][ 3 ] = {
		{ -1, 1, -1 },
		{ -1, 1, 1 },
		{ 1, 1, 1 },
		{ 1, 1, -1 },
		
		{ -1, -1, -1 },
		{ -1, -1, 1 },
		{ 1, -1, 1 },
		{ 1, -1, -1 }
	};
	
	glBegin( GL_QUADS );
	{
		// top
		glNormal3f( 0, 1, 0 );
		glVertex3fv( points[0] );
		glNormal3f( 0, 1, 0 );
		glVertex3fv( points[1] );
		glNormal3f( 0, 1, 0 );
		glVertex3fv( points[2] );
		glNormal3f( 0, 1, 0 );
		glVertex3fv( points[3] );
		
		// bottom
		glNormal3f( 0, -1, 0 );
		glVertex3fv( points[7] );
		glNormal3f( 0, -1, 0 );
		glVertex3fv( points[6] );
		glNormal3f( 0, -1, 0 );
		glVertex3fv( points[5] );
		glNormal3f( 0, -1, 0 );
		glVertex3fv( points[4] );
		
		// left
		glNormal3f( -1, 0, 0 );
		glVertex3fv( points[0] );
		glNormal3f( -1, 0, 0 );
		glVertex3fv( points[4] );
		glNormal3f( -1, 0, 0 );
		glVertex3fv( points[5] );
		glNormal3f( -1, 0, 0 );
		glVertex3fv( points[1] );
		
		// right
		glNormal3f( 1, 0, 0 );
		glVertex3fv( points[2] );
		glNormal3f( 1, 0, 0 );
		glVertex3fv( points[6] );
		glNormal3f( 1, 0, 0 );
		glVertex3fv( points[7] );
		glNormal3f( 1, 0, 0 );
		glVertex3fv( points[3] );
		
		// front
		glNormal3f( 0, 0, 1 );
		glVertex3fv( points[1] );
		glNormal3f( 0, 0, 1 );
		glVertex3fv( points[5] );
		glNormal3f( 0, 0, 1 );
		glVertex3fv( points[6] );
		glNormal3f( 0, 0, 1 );
		glVertex3fv( points[2] );
		
		// back
		glNormal3f( 0, 0, -1 );
		glVertex3fv( points[3] );
		glNormal3f( 0, 0, -1 );
		glVertex3fv( points[7] );
		glNormal3f( 0, 0, -1 );
		glVertex3fv( points[4] );
		glNormal3f( 0, 0, -1 );
		glVertex3fv( points[0] );
	}
	glEnd();
	glEndList();
}

// Draws a box
void drawBox( float size )
{
	if ( size != 1 )
	{
		glPushMatrix();
		glScalef( size, size, size );
	}

	glCallList( boxDisplayList );

	if ( size != 1 )
		glPopMatrix();
}
