/*	  Copyright (C) 2000,2001,2002  Sony Computer Entertainment America
       	  
       	  This file is subject to the terms and conditions of the GNU Lesser
	  General Public License Version 2.1. See the file "COPYING" in the
	  main directory of this archive for more details.                             */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "GL/gl.h"
#include "GL/glut.h"
#include "GL/ps2gl.h"

#include "boxfield.h"
#include "effect.h"
#include "miscrender.h"
#include "sound.h"
#include "textures.h"
#include "textview.h"

#include "taateffect.h"

/********************************************
 * prototypes
 */

void init(void);
void init_lights(void);
void set_light_positions();

void draw_cube(void);

void display(void);
void reshape(int w, int h);
void key(unsigned char k, int x, int y);
void special(int key, int x, int y);

/********************************************
 * static data
 */

static Effect *effect = 0;

/********************************************
 * code
 */

int
main(int argc, char **argv)
{
	glutInit( &argc, argv );
	
	// need to set up the gl context with glutInit before calling init()
	init();
	
	glutReshapeFunc( reshape );
	glutDisplayFunc( display );
	glutKeyboardFunc( key );
	
	glutMainLoop();
	
	return 0;
}

void
init(void)
{
//	srand( time( NULL ) );
	srand( 94873683 );

	initTextures();
	initMisc();

	boxfieldInit();
	textviewInit();

	soundInit();
	soundStartMP3( "music" );

	glClearColor( 0.3f, 0.3f, 0.4f, 0.0f );
	
//	glEnable( GL_DEPTH_TEST );
	glEnable( GL_RESCALE_NORMAL );
	
	effect = new TaatEffect();
}

void display()
{
	if ( effect == 0 )
		exit( 0 );

	// Update
	textviewUpdate();

	Effect *newEffect = effect->update();
	if ( newEffect != effect )
		delete effect;
	effect = newEffect;

	// All done?
	if ( effect == 0 )
	{
		pglFinish();
		exit( 0 );
	}

	// Render
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	// Draw the scene
	effect->render();
	
	// Draw the text
	textviewRender();

	// Swap buffers
	glFlush();
	glutPostRedisplay();
	glutSwapBuffers();
}

void perspective( float fov, float aspect, float nearClip, float farClip )
{
	float w, h;
	fov *= 3.141592654f / 180.0f;
	h = 2.0f * nearClip * ( float ) tanf( fov / 2.0f );
	w = h * aspect;
	
	glFrustum( -w / 2.0f, w / 2.0f, -h / 2.0f, h / 2.0f, nearClip, farClip );
}

void reshape( int w, int h )
{
	glViewport( 0, 0, w, h );
	
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	perspective( 40.0f, ( float ) w / ( float ) h, 1.0f, 4000.0f );
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
}

void key( unsigned char k, int x, int y )
{
   switch (k) {
      case '8':
	 break;
      case '2':
	 break;
      case '4':
	 break;
      case '6':
	 break;

      case 27:  /* Escape */
	 exit(0);
	 break;
      default:
	 return;
   }
}
