#include <stdlib.h>
#include "GL/gl.h"

#include "boxfield.h"
#include "endfadeeffect.h"
#include "greeteffect.h"
#include "textures.h"
#include "textview.h"

#define TEXTPAUSE 45

// Names of all the greet persons
static const char *greetList[] =
{
    "addiction",
    "amuq",
    "ananasmurska",
    "armada",
    "(b)",
    "c.a.p.",
    "coral",
    "dark codex",
    "ddg",
    "fascination",
    "future crew",
    "grin",
    "hubris",
    "kiuas.net",
    "lancer",
    "mbnet",
    "noice",
    "paranoids",
    "pihtisoft",
    "puolijohde",
    "pwp",
    "recreation",
    "scene.ee",
    "sonic pc",
    "static",
    "symptom",
    "unique",
    "10tons",
};
static const int greetListSize = sizeof( greetList ) / sizeof( greetList[ 0 ] );

////////

GreetEffect::GreetEffect():
	myCamSpin( 0 ), myCamDist( 8 ), myCamTilt( 0 ), myTextPos( 0 ), myTextPause( TEXTPAUSE * 4 ),
	myEndMode( false )
{
	myTextIds[ 0 ] = myTextIds[ 1 ] = myTextIds[ 2 ] = -1;

	textviewClear();

	glClearColor( 0.3f, 0.3f, 0.4f, 0.0f );
	initLight( 0, 0, 10, 0, 200, 200, 200 );
}

GreetEffect::~GreetEffect()
{
}

// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
Effect *GreetEffect::update()
{
	myCamSpin += 0.25f;

	if ( !myEndMode &&
	     myTextPause-- <= 0 )
	{
		// Remove the oldest text
		textviewRemove( myTextIds[ 0 ] );
		for ( int i = 0; i < ( 3 - 1 ); ++i )
			myTextIds[ i ] = myTextIds[ i + 1 ];
		myTextIds[ 2 ] = -1;

		// Add a new text?
		if ( myTextPos < greetListSize )
		{
			const char *text = greetList[ myTextPos++ ];
			int x = rand() % ( 630 - textviewWidth( text, 6 ) );
			int y = ( 480 / 6 ) + ( 480 / 3 ) * ( myTextPos % 3 ) - ( textviewHeight( text, 6 ) / 2 );

			// Add the text
			myTextIds[ 2 ] = textviewWrite( text, x, y, 6 );

			// Add a box
			boxfieldAdd( textureGreet );
		}

		// Set a new pause
		myTextPause = TEXTPAUSE;
		if ( myTextPos >= greetListSize &&
		     myTextIds[ 0 ] == -1 )
		{
			myEndMode = true;
		}
	}

	// End mode?
	if ( myEndMode )
	{
		myCamDist += 0.09f;
		myCamTilt += 0.4f;

		// All done?
		if ( myCamTilt > 30.f )
			return new EndFadeEffect();
	}

	boxfieldUpdate();

	return this;
}

// Renders the effects current frame
void GreetEffect::render()
{
	// Camera
	glRotatef( -myCamTilt * 3.f, 1, 0, 0 );
	glRotatef( -myCamTilt, 0, 1, 0 );
	glTranslatef( 0, 0, -myCamDist );
	glRotatef( 35, 1, 0, 0 );
	glRotatef( myCamSpin, 0, 1, 0 );

	// Init the states
	glEnable( GL_LIGHTING );
      
	static float material_diff_amb[] = { 0.5f, 0.5f, 0.5f, 0 };
	glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, material_diff_amb );

	// The field	
	boxfieldRender();

	// The mirror field
	glScalef( 1, -1, 1 );

	boxfieldRender();

	// The floor
	glDisable( GL_LIGHTING );
	glEnable( GL_BLEND );
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

	setTexture( textureGreetFloor, textureGreetFloorCLUT );

	glBegin( GL_TRIANGLE_STRIP );
	{
		float size = 3.51f;
		glNormal3f( 0, 1, 0 );
		glTexCoord2f( 0, 1 );
		glVertex3f( -size, 0,  size );
		glTexCoord2f( 1, 1 );
		glVertex3f(  size, 0,  size );
		glTexCoord2f( 0, 0 );
		glVertex3f( -size, 0, -size );
		glTexCoord2f( 1, 0 );
		glVertex3f(  size, 0, -size );
	}
	glEnd();
}
