// Fade screen effect
#ifndef __FADEEFFECT_H
#define __FADEEFFECT_H
#include "effect.h"

class FadeEffect : public Effect
{
public:
	enum NextEffect {
		Effect_BoxScr,
		Effect_Pipe,
		Effect_Trail,
		Effect_Greet,
	};

	FadeEffect( float sr, float sg, float sb,
	            NextEffect next,
	            float dr, float dg, float db,
	            int steps );
	virtual ~FadeEffect();

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update();

	// Renders the effects current frame
	virtual void render();

private:
	// The color
	float myR, myG, myB;
	// The color add
	float myRAdd, myGAdd, myBAdd;
	
	// Steps left
	int mySteps;
	
	// The next effect
	NextEffect myNext;
};

#endif
