#include "GL/gl.h"

#include "boxscreffect.h"
#include "fadeeffect.h"
#include "greeteffect.h"
#include "pipeeffect.h"
#include "textview.h"
#include "traileffect.h"

FadeEffect::FadeEffect( float sr, float sg, float sb,
                        NextEffect next,
                        float dr, float dg, float db,
                        int steps ):
	myR( sr ), myG( sg ), myB( sb ),
	myRAdd( ( dr - sr ) / ( float ) steps ),
	myGAdd( ( dg - sg ) / ( float ) steps ),
	myBAdd( ( db - sb ) / ( float ) steps ),
	mySteps( steps ),
	myNext( next )
{
	glClearColor( myR, myG, myB, 0.0f );

	textviewClear();
}

FadeEffect::~FadeEffect()
{
}

// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
Effect *FadeEffect::update()
{
	// Set the new color
	glClearColor( myR, myG, myB, 0.0f );
	myR += myRAdd;
	myG += myGAdd;
	myB += myBAdd;

	// Timeout?
	if ( mySteps-- <= 0 )
	{
		switch ( myNext )
		{
		case Effect_BoxScr:	return new BoxScrEffect();
		case Effect_Pipe:	return new PipeEffect();
		case Effect_Trail:	return new TrailEffect();
		case Effect_Greet:	return new GreetEffect();
		default:		return 0;
		}
	}

	return this;
}

// Renders the effects current frame
void FadeEffect::render()
{
}
