/* verticalblur.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "effect.h"
#include "verticalblur.h"

void verticalblur_run(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  int amount=data->amount;
  unsigned long *source=data->source->data;
  unsigned long *dest=data->dest->data;
  int width=data->dest->width, height=data->dest->height, x, y, bufptr=0;

  if(amount<=2)
    memcpy(dest, source, width*height*sizeof(unsigned long));
  else {
    int *a=(int *)calloc(width, sizeof(int));
    int *r=(int *)calloc(width, sizeof(int));
    int *g=(int *)calloc(width, sizeof(int));
    int *b=(int *)calloc(width, sizeof(int));
    unsigned long **ranges=(unsigned long **)calloc(width,
						    sizeof(unsigned long *));

    for(x=0; x<width; x++) {
      int tempbufptr=bufptr;
      ranges[x]=(unsigned long *)calloc(amount, sizeof(unsigned long));

      /* Use pixels on the top edge instead of pixels outside the buffer */
      for(y=0; y<amount/2; y++) {
	ranges[x][tempbufptr]=*source;
	a[x]+=(ranges[x][tempbufptr]&0xff000000)>>24;
	r[x]+=(ranges[x][tempbufptr]&0xff0000)>>16;
	g[x]+=(ranges[x][tempbufptr]&0xff00)>>8;
	b[x]+=(ranges[x][tempbufptr++]&0xff);      
	tempbufptr%=amount;
      }
      source++;
    }
    source-=width;
    bufptr+=amount/2;
    bufptr%=amount;

    /* Fill in the rest of the range */
    for(y=0; y<amount/2; y++) {
      for(x=0; x<width; x++) {
	ranges[x][bufptr]=*source++;
	a[x]+=(ranges[x][bufptr]&0xff000000)>>24;
	r[x]+=(ranges[x][bufptr]&0xff0000)>>16;
	g[x]+=(ranges[x][bufptr]&0xff00)>>8;
	b[x]+=(ranges[x][bufptr]&0xff);      
      }
      bufptr++;
      bufptr%=amount;
    }

    /* Normal operation, actually output data */
    for(y=0; y<height-amount/2; y++) {
      for(x=0; x<width; x++) {
	a[x]-=(ranges[x][bufptr]&0xff000000)>>24;
	r[x]-=(ranges[x][bufptr]&0xff0000)>>16;
	g[x]-=(ranges[x][bufptr]&0xff00)>>8;
	b[x]-=(ranges[x][bufptr]&0xff);
	ranges[x][bufptr]=*source++;
	a[x]+=(ranges[x][bufptr]&0xff000000)>>24;
	r[x]+=(ranges[x][bufptr]&0xff0000)>>16;
	g[x]+=(ranges[x][bufptr]&0xff00)>>8;
	b[x]+=(ranges[x][bufptr]&0xff);      
	*dest++=((a[x]/amount)<<24)|((r[x]/amount)<<16)|
	  ((g[x]/amount)<<8)|(b[x]/amount);
      }
      bufptr++;
      bufptr%=amount;
    }

    /* Use pixels on the bottom edge instead of pixels outside the buffer */
    for(y=0; y<amount/2; y++) {
      source-=width;
      for(x=0; x<width; x++) {
	a[x]-=(ranges[x][bufptr]&0xff000000)>>24;
	r[x]-=(ranges[x][bufptr]&0xff0000)>>16;
	g[x]-=(ranges[x][bufptr]&0xff00)>>8;
	b[x]-=(ranges[x][bufptr]&0xff);
	ranges[x][bufptr]=*source++;
	a[x]+=(ranges[x][bufptr]&0xff000000)>>24;
	r[x]+=(ranges[x][bufptr]&0xff0000)>>16;
	g[x]+=(ranges[x][bufptr]&0xff00)>>8;
	b[x]+=(ranges[x][bufptr]&0xff);      
	*dest++=((a[x]/amount)<<24)|((r[x]/amount)<<16)|
	  ((g[x]/amount)<<8)|(b[x]/amount);
      }
      bufptr++;
      bufptr%=amount;
    }

    for(x=0; x<width; x++)
      free(ranges[x]);
    free(ranges);
    free(a);
    free(r);
    free(g);
    free(b);
  }
}

void verticalblur_free(effect *effect) {
  free(effect->data);
}

void verticalblur_new(effect *effect) {
  effect->run=verticalblur_run;
  effect->new=verticalblur_new;
  effect->freee=verticalblur_free;
  effect->data=(verticalblur_data *)calloc(sizeof(verticalblur_data), 1);
}
