/* main.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#ifdef WINDOWS
#include <Windows.h>
#define M_PI 3.14159265358979323846
#else
#include <sys/time.h>
#include <unistd.h>
#endif
#include <math.h>
#include <SDL.h>
#include <SDL_audio.h>
#include "assembly2002demo.h"
#include "buffer.h"
#include "effect.h"
#include "mp3.h"

#define SKIP SONGPOSTOTIME(1, 0)

buffer screenbuffer;
long curtime=0;
int quit=0, timelinepos=0, sinus[1024];
effectlistentry *effectlist=NULL;
#ifdef WINDOWS
DWORD starttc;
#else
struct timeval tv, starttv;
struct timezone tz;
#endif

int main(int argc, char **argv) {
  SDL_AudioSpec desired={ 44100, AUDIO_S16LSB, 2, 0, 2048, 0, 0, playmp3, 0 };
  SDL_AudioSpec obtained;
  SDL_Surface *screen;
  SDL_Event event;
  Uint32 flags;
  effectlistentry *entry;
  int i;

  /* Check if fullscreen mode was requested */
  if(argc>1 && strcmp(argv[1], "--windowed")==0)
    flags=SDL_SWSURFACE|SDL_DOUBLEBUF;
  else
#ifdef WINDOWS
    flags=SDL_SWSURFACE|SDL_FULLSCREEN;
#else
    flags=SDL_SWSURFACE|SDL_FULLSCREEN|SDL_DOUBLEBUF;
#endif

  /* Initialize the SDL library */
  if(SDL_Init(SDL_INIT_VIDEO)<0) {
    fprintf(stderr, "Couldn't initialize SDL: %s\n", SDL_GetError());
    exit(1);
  }

  /* Allocate a temporary buffer and open audio system */
  desired.userdata=(Uint8 *)calloc(2*2*4096, sizeof(Uint8));
  if(SDL_OpenAudio(&desired, &obtained)<0) {
    fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
    exit(1);
  }

  /* Open an MP3 file */
  if(openmp3(production_mp3_filename, obtained.size, desired.userdata, SKIP)) {
    fprintf(stderr, "Couldn't open MP3 file %s\n", production_mp3_filename);
    exit(1);
  }

  /* Have a preference for 32-bit */
  if(!(screen=SDL_SetVideoMode(screenwidth, screenheight, 32, flags))) {
    fprintf(stderr, "Couldn't set %dx%dx32 video mode: %s\n",
	    screenwidth, screenheight, SDL_GetError());
    exit(1);
  }
  SDL_WM_SetCaption(production_window_title, production_window_title);
  SDL_ShowCursor(SDL_DISABLE);

  /* Create a buffer for the screen */
  screenbuffer.data=((unsigned long *)screen->pixels);
  screenbuffer.width=screenwidth;
  screenbuffer.height=screenheight;

  /* Initialize the production */
  production_startup();

  /* Create a sinus table */
  for(i=0; i<1024; i++)
    sinus[i]=(int)(sin(i*M_PI/512)*255);

  /* Get the initial time of day */
#ifdef WINDOWS
  starttc=GetTickCount();
#else
  gettimeofday(&starttv, &tz);
#endif

  /* Start audio playback */
  SDL_PauseAudio(0);

  while(!(quit)) {
#ifdef SHOWFPS
    long oldcurtime;
#endif
    /* Get time of day for timing */
#ifdef SHOWFPS
    oldcurtime=curtime;
#endif
#ifdef WINDOWS
    curtime=GetTickCount()-starttc;
#else
    gettimeofday(&tv, &tz);
    curtime=((tv.tv_sec-starttv.tv_sec)*1000+(tv.tv_usec-starttv.tv_usec)/1000);
#endif

#ifdef SHOWFPS
    printf("FPS: %f\n", 1000/(float)(curtime-oldcurtime));
#endif

    /* Check the timeline if we're supposed to do something */
    while(curtime+SKIP>=timeline[timelinepos].time) {
      if(timeline[timelinepos].job!=NULL) {
	timeline[timelinepos].job();
	timelinepos++;
      } else
	break;
    }

    /* Run all effects scheduled to run now */
    entry=effectlist;
    while(entry!=NULL) {
      if(entry->effect->parameters)
	entry->effect->parameters(entry->effect->data, curtime+SKIP);
      if(entry->effect->run)
	entry->effect->run(entry->effect->data, curtime+SKIP);
      entry=entry->next;
    }

    /* Double buffering */
    SDL_Flip(screen);

    /* Quit if window closed or escape pressed */
    while(SDL_PollEvent(&event)) {
      switch(event.type) {
      case SDL_QUIT:
	quit=1;
	break;
      case SDL_KEYUP:
	if(event.key.keysym.sym==SDLK_ESCAPE)
	  quit=1;
	break;
      default:
	break;
      }
    }
  }

  /* ..and die */
  SDL_CloseAudio();
  SDL_Quit();
  closemp3();
  free(desired.userdata);
  production_shutdown();

  return 0;
}
