/* assembly2002demo27.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Zooming eye */
#include "assembly2002demo.h"

static void params_27_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time>2047)
    data->color=0;
  else 
    data->color=((255-time/8)<<24|0xffffff);
}

static void params_27_zoom(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  data->sourcewidth=(double)data->source->width*((double)(SONGPOSTOTIME(3, 0)-time)/8000);
  data->sourceheight=(double)data->source->height*((double)(SONGPOSTOTIME(3, 0)-time)/8000);
  data->sourcex=(data->source->width-data->sourcewidth)/2;
  data->sourcey=(data->source->height-data->sourceheight)/2;
}

static void params_27_stripes(void *d, long time) {
  horizontalstripes_data *data=(horizontalstripes_data *)d;
  int i;

  time-=PART_27_START;
  if(time<0)
    time=0;

  for(i=0; i<data->height; i++)
    data->alphas[i]=255*pow(sin((double)i*M_PI/data->height*((double)(SONGPOSTOTIME(3, 0)-time)/8000)+M_PI/2*(double)time/8000), 5);
}

static void params_27_copy(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  data->alpha=160+95*time/SONGPOSTOTIME(3, 0);
}

static void params_27_bg(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int backgrounds[]={
    FACTORY1, TRAFFIC1, TRAINBG, TRAFFIC9,
    CRANE2, FACTORY2, FUEL1, PHONE,
    CRANE1, FACTORY3, SHIPYARD1, LAPTOP9,
    MOTHERBOARD, POWERSTATION, FACTORY4, TRAFFIC10
  };

  time-=PART_27_START;
  if(time<0)
    time=0;

  data->source=pictures[backgrounds[(time/125)%16]];
  data->alpha=255-255*time/SONGPOSTOTIME(3, 0);
}

static void params_27_copy_what(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 20))
    data->alpha=0;
  else {
    data->alpha=255;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_copy_about(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  
  if(time<SONGPOSTOTIME(2, 24))
    data->alpha=0;
  else {
    data->alpha=191;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_copy_the(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 28))
    data->alpha=0;
  else {
    data->alpha=223;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_copy_problems2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 31))
    data->alpha=0;
  else {
    data->alpha=239;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_copy_ofthe(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 40))
    data->alpha=0;
  else {
    data->alpha=191;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_copy_mind(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 46))
    data->alpha=0;
  else {
    data->alpha=255;
    data->destx+=(rand()%5)-2;
    data->desty+=(rand()%5)-2;
  }
}

static void params_27_stripes2(void *d, long time) {
  horizontalstripes_data *data=(horizontalstripes_data *)d;
  int i;

  time-=PART_27_START;
  if(time<0)
    time=0;

  if(time>=SONGPOSTOTIME(2, 40))
    for(i=0; i<(time-SONGPOSTOTIME(2, 40))*data->height/SONGPOSTOTIME(1, 24);
	i+=2) {
      data->alphas[i]=0;
      data->alphas[data->height-1-i]=0;
    }
}

static void params_27_copy_design(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_27_START;
  if(time<0)
    time=0;

  data->source=pictures[DESIGN5+(time/SONGPOSTOTIME(1, 2))%4];
}

void part_27() {
  copy_data *copydata;
  horizontalstripes_data *hsdata;
  add_data *adddata;
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 12. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_27_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 11. Stripe it */
  effectlist=effectlistentry_new(effect_new(horizontalstripes_new,
					    params_27_stripes2), effectlist);
  hsdata=(verticalstripes_data *)effectlist->effect->data;
  hsdata->dest=&screenbuffer;
  hsdata->x=0;
  hsdata->y=0;
  hsdata->width=screenbuffer.width;
  hsdata->height=screenbuffer.height;
  hsdata->alphas=(unsigned char *)calloc(hsdata->height,
					 sizeof(unsigned char));
  for(i=0; i<hsdata->height; i++)
    hsdata->alphas[i]=255;

  /* 10. Copy mind */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_mind),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=225;
  copydata->desty=213;
  copydata->sourcewidth=pictures[MIND]->width;
  copydata->sourceheight=pictures[MIND]->height;
  copydata->destwidth=pictures[MIND]->width;
  copydata->destheight=pictures[MIND]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 9. Copy ofthe */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_ofthe),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[OFTHE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=172;
  copydata->desty=205;
  copydata->sourcewidth=pictures[OFTHE]->width;
  copydata->sourceheight=pictures[OFTHE]->height;
  copydata->destwidth=pictures[OFTHE]->width;
  copydata->destheight=pictures[OFTHE]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy problems2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_problems2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PROBLEMS2];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=166;
  copydata->desty=159;
  copydata->sourcewidth=pictures[PROBLEMS2]->width;
  copydata->sourceheight=pictures[PROBLEMS2]->height;
  copydata->destwidth=pictures[PROBLEMS2]->width;
  copydata->destheight=pictures[PROBLEMS2]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy the */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_the),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[THE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=127;
  copydata->desty=170;
  copydata->sourcewidth=pictures[THE]->width;
  copydata->sourceheight=pictures[THE]->height;
  copydata->destwidth=pictures[THE]->width;
  copydata->destheight=pictures[THE]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy about */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_about),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[ABOUT];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=177;
  copydata->desty=132;
  copydata->sourcewidth=pictures[ABOUT]->width;
  copydata->sourceheight=pictures[ABOUT]->height;
  copydata->destwidth=pictures[ABOUT]->width;
  copydata->destheight=pictures[ABOUT]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy what */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_what),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[WHAT];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=109;
  copydata->desty=131;
  copydata->sourcewidth=pictures[WHAT]->width;
  copydata->sourceheight=pictures[WHAT]->height;
  copydata->destwidth=pictures[WHAT]->width;
  copydata->destheight=pictures[WHAT]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4.5 Copy design */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy_design),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DESIGN5];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[DESIGN5]->width;
  copydata->sourceheight=pictures[DESIGN5]->height;
  copydata->destwidth=pictures[DESIGN5]->width;
  copydata->destheight=pictures[DESIGN5]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 4. Copy final image */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_copy),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TEMP];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy background */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_bg),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAFFIC1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=screenbuffer.width;
  copydata->sourceheight=screenbuffer.height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;

  /* 2. Stripe it */
  effectlist=effectlistentry_new(effect_new(horizontalstripes_new,
					    params_27_stripes), effectlist);
  hsdata=(verticalstripes_data *)effectlist->effect->data;
  hsdata->dest=pictures[TEMP];
  hsdata->x=0;
  hsdata->y=0;
  hsdata->width=pictures[TEMP]->width;
  hsdata->height=pictures[TEMP]->height;
  hsdata->alphas=(unsigned char *)calloc(hsdata->height,
					 sizeof(unsigned char));
  for(i=0; i<hsdata->height; i++)
    hsdata->alphas[i]=255*pow(sin((double)i*M_PI/hsdata->height), 5);

  /* 1. Copy temp image */
  effectlist=effectlistentry_new(effect_new(copy_new, params_27_zoom),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[EYE];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[EYE]->width;
  copydata->sourceheight=pictures[EYE]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
