/* assembly2002demo11.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Train */
#include "assembly2002demo.h"

static void params_11_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_09_START;
  if(time<0)
    time=0;

  while(time>=SONGPOSTOTIME(1, 32))
    time-=SONGPOSTOTIME(1, 32);

  if(time>511)
    data->color=0;
  else 
    data->color=((255-time/2)<<24|0xffffff);
}

static void params_11_copy_train(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->destx=400-(time-SONGPOSTOTIME(1, 0))/8;
  else if(time<SONGPOSTOTIME(2, 0))
    data->destx=400-SONGPOSTOTIME(1, 32)/8;
  else if(time<SONGPOSTOTIME(2, 32))
    data->destx=300-(time-SONGPOSTOTIME(1, 32))/8;
  else if(time<SONGPOSTOTIME(3, 0)) {
    /*
    data->sourcex=100;
    data->sourcewidth=data->source->width-100;
    data->destwidth=data->sourcewidth;
    */
    data->destx=0;
  }
}

static void params_11_horizontalstretch(void *d, long time) {
  horizontalstretch_data *data=(horizontalstretch_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  /* Golden section horizontally: 247 153 */
  if(time<SONGPOSTOTIME(2, 0)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(2, 32)) {
    data->position=300-150*sin((double)(time-SONGPOSTOTIME(2, 0))*M_PI/4/SONGPOSTOTIME(1, 32));
    data->length=data->dest->width-data->position;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->position=100+53*cos((double)(time-SONGPOSTOTIME(2, 32))*M_PI/3/SONGPOSTOTIME(1, 32));
    data->length=-data->position;
  }
}

static void params_11_copy_bullshitwhite(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32)) {
    if((time-SONGPOSTOTIME(1, 0))/8>255)
      data->alpha=255;
    else
      data->alpha=(time-SONGPOSTOTIME(1, 0))/8;
  } else
    data->alpha=0;
}

static void params_11_copy_straightelectric(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32)) {
    if((time-SONGPOSTOTIME(1, 0))/16>255)
      data->alpha=255;
    else
      data->alpha=(time-SONGPOSTOTIME(1, 0))/16;
  } else
    data->alpha=0;
}

static void params_11_copy_locomotives(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32)) {
    if((time-SONGPOSTOTIME(1, 0))/8>255)
      data->alpha=255;
    else
      data->alpha=(time-SONGPOSTOTIME(1, 0))/8;
  } else
    data->alpha=0;
}

static void params_11_copy_take(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 52))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_11_copy_you(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 56))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_11_copy_there(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 60))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(2, 0))
    data->alpha=255;
  else
    data->alpha=0;
}

static void params_11_copy_but(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32))
    data->alpha=0;
  else {
    if((time-SONGPOSTOTIME(2, 32))/8>255)
      data->alpha=255;
    else
      data->alpha=(time-SONGPOSTOTIME(2, 32))/8;
  }
}

static void params_11_copy_where(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32))
    data->alpha=0;
  else {
    if((time-SONGPOSTOTIME(2, 32))/8>255)
      data->alpha=255;
    else
      data->alpha=(time-SONGPOSTOTIME(2, 32))/8;
  }
}

static void params_11_clear1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 52))
    data->mode=COPY_MODE_ADD;
  else {
    data->mode=COPY_MODE_OVERWRITE;
    if(time<SONGPOSTOTIME(2, 60)) {
      data->sourceheight=100;
      data->destheight=100;
    } else if(time<SONGPOSTOTIME(3, 0)) {
      data->sourceheight=200;
      data->destheight=200;
    }
  }
}

static void params_11_clear2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_11_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 56))
    data->mode=COPY_MODE_ADD;
  else
    data->mode=COPY_MODE_OVERWRITE;
}

void part_11() {
  copy_data *copydata;
  horizontalstretch_data *hsdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 14. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_11_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0x00ffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 13. Clear 2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_11_clear2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=&screenbuffer;
  copydata->dest=&screenbuffer;
  copydata->destx=0;
  copydata->desty=200;
  copydata->sourcewidth=screenbuffer.width;
  copydata->sourceheight=100;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=100;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;

  /* 12. Clear 1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_11_clear1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=&screenbuffer;
  copydata->dest=&screenbuffer;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=screenbuffer.width;
  copydata->sourceheight=100;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=100;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;

  /* 11. Copy where */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_where),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[WHERE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=55;
  copydata->desty=206;
  copydata->sourcewidth=pictures[WHERE]->width;
  copydata->sourceheight=pictures[WHERE]->height;
  copydata->destwidth=pictures[WHERE]->width;
  copydata->destheight=pictures[WHERE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 10. Copy but */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_but),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BUT];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=25;
  copydata->desty=207;
  copydata->sourcewidth=pictures[BUT]->width;
  copydata->sourceheight=pictures[BUT]->height;
  copydata->destwidth=pictures[BUT]->width;
  copydata->destheight=pictures[BUT]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 9. Copy there */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_there),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[THERE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=60;
  copydata->desty=215;
  copydata->sourcewidth=pictures[THERE]->width;
  copydata->sourceheight=pictures[THERE]->height;
  copydata->destwidth=pictures[THERE]->width;
  copydata->destheight=pictures[THERE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy you */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_you),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[YOU];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=66;
  copydata->desty=190;
  copydata->sourcewidth=pictures[YOU]->width;
  copydata->sourceheight=pictures[YOU]->height;
  copydata->destwidth=pictures[YOU]->width;
  copydata->destheight=pictures[YOU]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy take */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_take),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TAKE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=66;
  copydata->desty=167;
  copydata->sourcewidth=pictures[TAKE]->width;
  copydata->sourceheight=pictures[TAKE]->height;
  copydata->destwidth=pictures[TAKE]->width;
  copydata->destheight=pictures[TAKE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy locomotives */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_locomotives),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LOCOMOTIVES];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=248;
  copydata->desty=32;
  copydata->sourcewidth=pictures[LOCOMOTIVES]->width;
  copydata->sourceheight=pictures[LOCOMOTIVES]->height;
  copydata->destwidth=pictures[LOCOMOTIVES]->width;
  copydata->destheight=pictures[LOCOMOTIVES]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy straightelectric */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_straightelectric),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[STRAIGHTELECTRIC];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=92;
  copydata->desty=32;
  copydata->sourcewidth=pictures[STRAIGHTELECTRIC]->width;
  copydata->sourceheight=pictures[STRAIGHTELECTRIC]->height;
  copydata->destwidth=pictures[STRAIGHTELECTRIC]->width;
  copydata->destheight=pictures[STRAIGHTELECTRIC]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy bullshitwhite */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_bullshitwhite),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITWHITE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=6;
  copydata->desty=250;
  copydata->sourcewidth=pictures[BULLSHITWHITE]->width;
  copydata->sourceheight=pictures[BULLSHITWHITE]->height;
  copydata->destwidth=pictures[BULLSHITWHITE]->width;
  copydata->destheight=pictures[BULLSHITWHITE]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Strech them */
  effectlist=effectlistentry_new(effect_new(horizontalstretch_new, params_11_horizontalstretch),
				 effectlist);
  hsdata=(horizontalstretch_data *)effectlist->effect->data;
  hsdata->dest=&screenbuffer;
  hsdata->position=0;
  hsdata->length=0;

  /* 2. Copy train */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_11_copy_train),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAIN];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=400;
  copydata->desty=65;
  copydata->sourcewidth=pictures[TRAIN]->width;
  copydata->sourceheight=pictures[TRAIN]->height;
  copydata->destwidth=pictures[TRAIN]->width;
  copydata->destheight=pictures[TRAIN]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 1. Copy train background */
  effectlist=effectlistentry_new(effect_new(copy_new, NULL),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TRAINBG];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TRAINBG]->width;
  copydata->sourceheight=pictures[TRAINBG]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
